/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MissingNonGreedyRequirement2
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit c1;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = MissingNonGreedyRequirement2.createIU("C", Version.create((String)"1.0.0"), true);
        IRequirement[] reqB = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true)};
        this.a1 = MissingNonGreedyRequirement2.createIU("A", Version.create((String)"1.0.0"), reqB);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.c1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = MissingNonGreedyRequirement2.createPlanner();
    }

    public void testInstall() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MissingNonGreedyRequirement2.assertEquals((int)4, (int)plan.getStatus().getSeverity());
    }

    public void testExplanation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MissingNonGreedyRequirement2.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        Set explanation = requestStatus.getExplanations();
        MissingNonGreedyRequirement2.assertFalse((boolean)explanation.isEmpty());
        MissingNonGreedyRequirement2.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.a1));
        MissingNonGreedyRequirement2.assertEquals((int)1, (int)requestStatus.getShortExplanation());
    }
}

