/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MultipleSingleton
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IInstallableUnit a3;
    IInstallableUnit a4;
    IInstallableUnit u;
    IInstallableUnit v;
    IInstallableUnit w;
    IInstallableUnit x;
    IInstallableUnit y;
    IInstallableUnit z;
    IInstallableUnit sdk1;
    IInstallableUnit sdk2;
    IInstallableUnit platform1;
    IInstallableUnit platform2;
    IInstallableUnit third1;
    IInstallableUnit third2;
    IInstallableUnit s1;
    IInstallableUnit s2;
    IInstallableUnit t1;
    IInstallableUnit t2;
    IInstallableUnit random;
    IPlanner planner;
    IProfile profile;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = MultipleSingleton.createIU("A", Version.create((String)"1.0.0"), true);
        this.a2 = MultipleSingleton.createIU("A", Version.create((String)"2.0.0"), true);
        this.a3 = MultipleSingleton.createIU("A", Version.create((String)"3.0.0"), false);
        this.a4 = MultipleSingleton.createIU("A", Version.create((String)"4.0.0"), false);
        this.x = MultipleSingleton.createIU("X", Version.createOSGi((int)2, (int)0, (int)0), MultipleSingleton.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "A", new VersionRange("[1.0.0, 4.1.0)")));
        IRequirement c1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement c2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[2.0.0, 2.0.0]"), null, (boolean)false, (boolean)false);
        this.y = MultipleSingleton.createIU("Y", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{c1, c2});
        IRequirement c3 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[3.0.0, 3.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement c4 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[4.0.0, 4.0.0]"), null, (boolean)false, (boolean)false);
        this.z = MultipleSingleton.createIU("Z", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{c3, c4});
        IRequirement c5 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement c6 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[3.0.0, 3.0.0]"), null, (boolean)false, (boolean)false);
        this.w = MultipleSingleton.createIU("W", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{c5, c6});
        IRequirement c7 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 2.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement c8 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[3.0.0, 4.0.0]"), null, (boolean)false, (boolean)false);
        this.v = MultipleSingleton.createIU("V", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{c7});
        this.u = MultipleSingleton.createIU("U", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{c8});
        this.platform1 = MultipleSingleton.createIU("platform", Version.create((String)"1.0.0"), true);
        this.platform2 = MultipleSingleton.createIU("platform", Version.create((String)"2.0.0"), true);
        this.sdk1 = MultipleSingleton.createIU("sdk", Version.create((String)"1.0.0"), true);
        this.sdk2 = MultipleSingleton.createIU("sdk", Version.create((String)"2.0.0"), true);
        this.third1 = MultipleSingleton.createIU("third", Version.create((String)"1.0.0"), true);
        this.third2 = MultipleSingleton.createIU("third", Version.create((String)"2.0.0"), true);
        this.random = MultipleSingleton.createIU("random");
        IRequirement pr1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"platform", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement pr2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"platform", (VersionRange)new VersionRange("[2.0.0, 2.0.0]"), null, (boolean)false, (boolean)false);
        this.s1 = MultipleSingleton.createIU("s1", Version.createOSGi((int)1, (int)0, (int)0), new IRequirement[]{pr1});
        this.s2 = MultipleSingleton.createIU("s2", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{pr2});
        this.t1 = MultipleSingleton.createIU("t1", Version.createOSGi((int)1, (int)0, (int)0), new IRequirement[]{pr1});
        this.t2 = MultipleSingleton.createIU("t2", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{pr2});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a2, this.a3, this.a4, this.w, this.x, this.y, this.z, this.platform1, this.platform2, this.sdk1, this.sdk2, this.third1, this.third2, this.s1, this.s2, this.t1, this.t2, this.random});
        this.profile = this.createProfile("TestProfile.MultipleSingleton" + this.getName());
        this.planner = MultipleSingleton.createPlanner();
    }

    public void testSDKandThirdPartyConflict() {
        MultipleSingleton.assertOK(this.install(this.profile, new IInstallableUnit[]{this.s1, this.t1}, true, this.planner, MultipleSingleton.createEngine()));
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{this.s2});
        pcr.remove(this.s1);
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        MultipleSingleton.assertNotOK(plan.getStatus());
    }

    public void testSDKandPlatformBothRootsConflict() {
        MultipleSingleton.assertOK(this.install(this.profile, new IInstallableUnit[]{this.platform1, this.s1}, true, this.planner, MultipleSingleton.createEngine()));
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{this.s2});
        pcr.remove(this.s1);
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        MultipleSingleton.assertNotOK(plan.getStatus());
    }

    public void testSDKandPlatformBothRootsConflict2() {
        MultipleSingleton.assertOK(this.install(this.profile, new IInstallableUnit[]{this.platform1, this.s1}, true, this.planner, MultipleSingleton.createEngine()));
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{this.platform2});
        pcr.remove(this.platform1);
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)pcr, null, null);
        MultipleSingleton.assertNotOK(plan.getStatus());
    }

    public void test1() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.x});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MultipleSingleton.assertEquals((int)1, (int)MultipleSingleton.queryResultSize(((PlannerStatus)plan.getStatus()).getPlannedState().query(QueryUtil.createIUQuery((String)"X"), null)));
        MultipleSingleton.assertEquals((int)0, (int)plan.getStatus().getSeverity());
    }

    public void test2() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.y});
        MultipleSingleton.assertEquals((int)4, (int)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null).getStatus().getSeverity());
    }

    public void testExplanation2() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.y});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MultipleSingleton.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        Set explanation = requestStatus.getExplanations();
        MultipleSingleton.assertFalse((boolean)explanation.isEmpty());
        MultipleSingleton.assertEquals((int)2, (int)requestStatus.getShortExplanation());
        MultipleSingleton.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.y));
        MultipleSingleton.assertEquals((int)1, (int)requestStatus.getConflictsWithInstalledRoots().size());
    }

    public void test3() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.z});
        MultipleSingleton.assertEquals((int)0, (int)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null).getStatus().getSeverity());
    }

    public void test4() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.w});
        MultipleSingleton.assertEquals((int)4, (int)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null).getStatus().getSeverity());
    }

    public void testExplanation4() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.w});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MultipleSingleton.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        Set explanation = requestStatus.getExplanations();
        MultipleSingleton.assertFalse((boolean)explanation.isEmpty());
        MultipleSingleton.assertEquals((int)2, (int)requestStatus.getShortExplanation());
        MultipleSingleton.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.w));
    }

    public void test5b() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.u});
        MultipleSingleton.assertEquals((int)0, (int)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null).getStatus().getSeverity());
    }

    public void test5c() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.v});
        MultipleSingleton.assertEquals((int)0, (int)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null).getStatus().getSeverity());
    }

    public void test5() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.u, this.v});
        MultipleSingleton.assertEquals((int)4, (int)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null).getStatus().getSeverity());
    }

    public void testExplanation5() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.u, this.v});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MultipleSingleton.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        Set explanation = requestStatus.getExplanations();
        MultipleSingleton.assertFalse((boolean)explanation.isEmpty());
        MultipleSingleton.assertEquals((int)2, (int)requestStatus.getShortExplanation());
        MultipleSingleton.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.u));
        MultipleSingleton.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.v));
    }
}

