/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTest4
extends AbstractProvisioningTest {
    IInstallableUnit f1;
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit c1;
    IInstallableUnit d1;
    IInstallableUnit d2;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch p2;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.f1 = PatchTest4.createIU("F", Version.createOSGi((int)1, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true)});
        this.a1 = PatchTest4.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.b1 = PatchTest4.createIU("B", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.c1 = PatchTest4.createIU("C", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.d1 = PatchTest4.createIU("D", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.b2 = PatchTest4.createIU("B", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)new VersionRange("[2.0.0, 3.1.0)"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.d2 = PatchTest4.createIU("D", Version.createOSGi((int)2, (int)0, (int)0), true);
        IRequirementChange changeA = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0, 2.1.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirementChange changeC = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)new VersionRange("[2.0.0, 2.1.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"F", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false);
        IRequirement[][] scope = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.1.0]"), null, (boolean)false, (boolean)false, (boolean)false)}, {MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[1.0.0, 1.1.0]"), null, (boolean)false, (boolean)false, (boolean)false)}};
        this.p1 = PatchTest4.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{changeA, changeC}, scope, lifeCycle);
        this.p2 = PatchTest4.createIUPatch("P", Version.create((String)"2.0.0"), true, new IRequirementChange[]{changeA, changeC}, new IRequirement[0][0], lifeCycle);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.f1, this.a1, this.b1, this.b2, this.c1, this.d1, this.d2, this.p1});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTest4.createPlanner();
        this.engine = PatchTest4.createEngine();
    }

    public void testCompleteScenario() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.f1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTest4.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        PatchTest4.assertInstallOperand(plan1, this.b1);
        PatchTest4.assertInstallOperand(plan1, this.a1);
        PatchTest4.assertInstallOperand(plan1, this.f1);
        this.engine.perform(plan1, null);
        PatchTest4.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        PatchTest4.assertProfileContainsAll("B1 is missing", this.profile1, new IInstallableUnit[]{this.b1});
        PatchTest4.assertProfileContainsAll("C1 is missing", this.profile1, new IInstallableUnit[]{this.c1});
        PatchTest4.assertProfileContainsAll("D1 is missing", this.profile1, new IInstallableUnit[]{this.d1});
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.p1});
        req2.setInstallableUnitInclusionRules((IInstallableUnit)this.p1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p1));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        PatchTest4.assertTrue((4 != plan2.getStatus().getSeverity() ? 1 : 0) != 0);
        PatchTest4.assertInstallOperand(plan2, this.b2);
        PatchTest4.assertInstallOperand(plan2, this.d2);
        this.engine.perform(plan2, null);
        PatchTest4.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        PatchTest4.assertProfileContainsAll("B2 is missing", this.profile1, new IInstallableUnit[]{this.b2});
        PatchTest4.assertProfileContainsAll("P1 is missing", this.profile1, new IInstallableUnit[]{this.p1});
        PatchTest4.assertProfileContainsAll("C1 is missing", this.profile1, new IInstallableUnit[]{this.c1});
        PatchTest4.assertProfileContainsAll("D2 is missing", this.profile1, new IInstallableUnit[]{this.d2});
        PatchTest4.assertProfileContainsAll("F1 is missing", this.profile1, new IInstallableUnit[]{this.f1});
    }

    public void OfftestCompleteScenario2() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.f1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTest4.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        PatchTest4.assertInstallOperand(plan1, this.b1);
        PatchTest4.assertInstallOperand(plan1, this.a1);
        PatchTest4.assertInstallOperand(plan1, this.f1);
        this.engine.perform(plan1, null);
        PatchTest4.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        PatchTest4.assertProfileContainsAll("B1 is missing", this.profile1, new IInstallableUnit[]{this.b1});
        PatchTest4.assertProfileContainsAll("C1 is missing", this.profile1, new IInstallableUnit[]{this.c1});
        PatchTest4.assertProfileContainsAll("D1 is missing", this.profile1, new IInstallableUnit[]{this.d1});
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.p2});
        req2.setInstallableUnitInclusionRules((IInstallableUnit)this.p1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.p1));
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        PatchTest4.assertTrue((4 != plan2.getStatus().getSeverity() ? 1 : 0) != 0);
        PatchTest4.assertInstallOperand(plan2, this.b2);
        PatchTest4.assertInstallOperand(plan2, this.d2);
        this.engine.perform(plan2, null);
        PatchTest4.assertProfileContainsAll("A1 is missing", this.profile1, new IInstallableUnit[]{this.a1});
        PatchTest4.assertProfileContainsAll("B2 is missing", this.profile1, new IInstallableUnit[]{this.b2});
        PatchTest4.assertProfileContainsAll("P1 is missing", this.profile1, new IInstallableUnit[]{this.p1});
        PatchTest4.assertProfileContainsAll("C1 is missing", this.profile1, new IInstallableUnit[]{this.c1});
        PatchTest4.assertProfileContainsAll("D2 is missing", this.profile1, new IInstallableUnit[]{this.d2});
        PatchTest4.assertProfileContainsAll("F1 is missing", this.profile1, new IInstallableUnit[]{this.f1});
    }
}

