/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTest6
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit c1;
    IInstallableUnit d1;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch pp1;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = PatchTest6.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true)});
        this.b1 = PatchTest6.createIU("B", Version.createOSGi((int)1, (int)2, (int)0), true);
        this.c1 = PatchTest6.createIU("C", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true)});
        this.d1 = PatchTest6.createIU("D", Version.createOSGi((int)1, (int)2, (int)0), true);
        IRequirementChange changeA = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement[][] scopeP1 = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false)}};
        IRequirement[] reqOnPP = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"PP", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)true)};
        this.p1 = PatchTest6.createIUPatch("P", Version.create((String)"1.0.0"), null, reqOnPP, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, new IRequirementChange[]{changeA}, scopeP1, null, new IRequirement[0]);
        IRequirementChange changeC = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement[][] scopePP1 = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false)}};
        this.pp1 = PatchTest6.createIUPatch("PP", Version.create((String)"1.0.0"), true, new IRequirementChange[]{changeC}, scopePP1, null);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.c1, this.d1, this.p1, this.pp1});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTest6.createPlanner();
        this.engine = PatchTest6.createEngine();
    }

    public void testInstall() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.c1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTest6.assertEquals((int)4, (int)plan1.getStatus().getSeverity());
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.c1, this.pp1});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        PatchTest6.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.p1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        PatchTest6.assertEquals((int)0, (int)plan3.getStatus().getSeverity());
        ProfileChangeRequest req4 = new ProfileChangeRequest(this.profile1);
        req4.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        IProvisioningPlan plan4 = this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        PatchTest6.assertEquals((int)0, (int)plan4.getStatus().getSeverity());
        PatchTest6.assertInstallOperand(plan4, this.a1);
        PatchTest6.assertInstallOperand(plan4, (IInstallableUnit)this.p1);
        PatchTest6.assertInstallOperand(plan4, (IInstallableUnit)this.pp1);
        PatchTest6.assertInstallOperand(plan4, this.b1);
        ProfileChangeRequest req5 = new ProfileChangeRequest(this.profile1);
        req5.addInstallableUnits(new IInstallableUnit[]{this.a1, this.c1, this.p1});
        IProvisioningPlan plan5 = this.planner.getProvisioningPlan((IProfileChangeRequest)req5, null, null);
        PatchTest6.assertEquals((int)0, (int)plan5.getStatus().getSeverity());
        PatchTest6.assertInstallOperand(plan4, this.a1);
        PatchTest6.assertInstallOperand(plan4, (IInstallableUnit)this.p1);
        PatchTest6.assertInstallOperand(plan4, this.b1);
        PatchTest6.assertInstallOperand(plan4, (IInstallableUnit)this.pp1);
        PatchTest6.assertInstallOperand(plan5, this.d1);
        PatchTest6.assertInstallOperand(plan5, this.c1);
    }

    public void testExplanation1() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.c1});
        ProvisioningPlan plan1 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTest6.assertEquals((int)4, (int)plan1.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan1.getStatus()).getRequestStatus();
        PatchTest6.assertEquals((int)1, (int)requestStatus.getShortExplanation());
        Set conflictingRoots = requestStatus.getConflictsWithInstalledRoots();
        PatchTest6.assertEquals((int)1, (int)conflictingRoots.size());
        PatchTest6.assertTrue((conflictingRoots.contains(this.a1) || conflictingRoots.contains(this.c1) ? 1 : 0) != 0);
    }
}

