/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTest8
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit c2;
    IInstallableUnit f1;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch r1;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = PatchTest8.createIU("A", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.a2 = PatchTest8.createIU("A", Version.create((String)"2.0.0"), true);
        this.b1 = PatchTest8.createIU("B", Version.create((String)"1.0.0"), true);
        this.b2 = PatchTest8.createIU("B", Version.create((String)"2.0.0"), true);
        this.c2 = PatchTest8.createIU("C", Version.create((String)"2.0.0"), true);
        IRequirement[] req = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[2.0.0, 3.1.0)"), null, (boolean)false, (boolean)true)};
        this.f1 = PatchTest8.createIU("F", Version.createOSGi((int)1, (int)0, (int)0), req);
        IRequirementChange changeA = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[2.0.0, 3.0.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement[][] scope = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"F", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false)}};
        this.p1 = PatchTest8.createIUPatch("P", Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, new IRequirementChange[]{changeA}, scope, null, new IRequirement[0]);
        IRequirementChange changeB = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0, 3.0.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement[][] scopePP = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"F", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false)}};
        this.r1 = PatchTest8.createIUPatch("R", Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, new IRequirementChange[]{changeB}, scopePP, null, new IRequirement[0]);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a2, this.b1, this.b2, this.c2, this.f1, this.p1, this.r1});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTest8.createPlanner();
        this.engine = PatchTest8.createEngine();
    }

    public void testOneIUWithMultiplePatchesApplyingOnIt() {
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.f1, this.p1, this.r1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        PatchTest8.assertEquals((int)0, (int)plan3.getStatus().getSeverity());
    }
}

