/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URI;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTestUpdate3
extends AbstractProvisioningTest {
    private static final String PP2 = "PatchForIUP2";
    private static final String PP1 = "PatchForIUP1";
    private static final String P2 = "P2";
    private static final String P1 = "P1";
    private static final String P2_FEATURE = "p2.feature";
    private IInstallableUnit p2Feature;
    private IInstallableUnit p2Feature20;
    private IInstallableUnit p1;
    private IInstallableUnit p2;
    private IInstallableUnitPatch pp1;
    private IInstallableUnitPatch pp2;
    private IInstallableUnit p2b;
    private IInstallableUnit p1b;
    private IPlanner planner;
    private IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.p2Feature = PatchTestUpdate3.createIU(P2_FEATURE, Version.createOSGi((int)1, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.p1 = PatchTestUpdate3.createIU(P1, Version.createOSGi((int)1, (int)0, (int)0), true);
        this.p2 = PatchTestUpdate3.createIU(P2, Version.createOSGi((int)1, (int)0, (int)0), true);
        this.p1b = PatchTestUpdate3.createIU(P1, Version.createOSGi((int)1, (int)1, (int)1), true);
        this.p2b = PatchTestUpdate3.createIU(P2, Version.createOSGi((int)1, (int)1, (int)1), true);
        IRequirementChange changepp1 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)new VersionRange("[1.1.1, 1.1.1]"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCyclepp1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0, 3.0.0]"), null, (boolean)false, (boolean)false, (boolean)true);
        IRequirement[][] scopepp1 = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0, 3.0.0]"), null, (boolean)false, (boolean)false)}};
        this.pp1 = PatchTestUpdate3.createIUPatch(PP1, Version.create((String)"3.0.0"), true, new IRequirementChange[]{changepp1}, scopepp1, lifeCyclepp1);
        IRequirementChange changepp2 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)new VersionRange("[1.1.1, 1.1.1]"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCyclepp2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true);
        IRequirement[][] scopepp2 = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false)}};
        this.pp2 = PatchTestUpdate3.createIUPatch(PP2, Version.create((String)"5.0.0"), true, new IRequirementChange[]{changepp2}, scopepp2, lifeCyclepp2);
        this.p2Feature20 = PatchTestUpdate3.createIU(P2_FEATURE, Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.p2Feature, this.p1, this.p2, this.p1b, this.p2b, this.pp1, this.pp2, this.p2Feature20});
        this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTestUpdate3.createPlanner();
        this.engine = PatchTestUpdate3.createEngine();
        if (!this.install(this.getProfile("TestProfile." + this.getName()), new IInstallableUnit[]{this.p2Feature}, true, this.planner, this.engine).isOK()) {
            PatchTestUpdate3.fail((String)"Setup failed");
        }
        if (!this.install(this.getProfile("TestProfile." + this.getName()), new IInstallableUnit[]{this.pp1}, false, this.planner, this.engine).isOK()) {
            PatchTestUpdate3.fail((String)"Setup failed");
        }
        if (!this.install(this.getProfile("TestProfile." + this.getName()), new IInstallableUnit[]{this.pp2}, false, this.planner, this.engine).isOK()) {
            PatchTestUpdate3.fail((String)"Setup failed");
        }
        PatchTestUpdate3.assertProfileContainsAll("Profile setup incorrectly", this.getProfile("TestProfile." + this.getName()), new IInstallableUnit[]{this.p2Feature, this.pp1, this.p1b, this.pp2, this.p2b});
    }

    public void testUpdate() {
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.getProfile("TestProfile." + this.getName()));
        ProvisioningContext ctx = new ProvisioningContext(PatchTestUpdate3.getAgent());
        ctx.setMetadataRepositories(new URI[0]);
        PatchTestUpdate3.assertOK("Validating the profile", this.planner.getProvisioningPlan((IProfileChangeRequest)req2, ctx, null).getStatus());
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.getProfile("TestProfile." + this.getName()));
        req1.addInstallableUnits(new IInstallableUnit[]{this.p2Feature20});
        req1.setInstallableUnitInclusionRules(this.p2Feature20, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.p2Feature20));
        req1.removeInstallableUnits(new IInstallableUnit[]{this.p2Feature});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTestUpdate3.assertEquals((boolean)true, (4 != plan.getStatus().getSeverity() ? 1 : 0) != 0);
        this.engine.perform(plan, null);
        PatchTestUpdate3.assertProfileContains("The profile contains unexpected IUs", this.getProfile("TestProfile." + this.getName()), new IInstallableUnit[]{this.p2Feature20, this.p1b, this.pp1, this.p2});
    }
}

