/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTestUsingNegativeRequirement
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit c1;
    IInstallableUnitPatch p1;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = PatchTestUsingNegativeRequirement.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)true)});
        this.b1 = PatchTestUsingNegativeRequirement.createIU("B", Version.createOSGi((int)1, (int)2, (int)0), true);
        this.c1 = PatchTestUsingNegativeRequirement.createIU("C", Version.createOSGi((int)1, (int)0, (int)0), true);
        RequiredCapability negativeRequirementForPatch = new RequiredCapability("org.eclipse.equinox.p2.iu", "B", VersionRange.emptyRange, null, 0, 0, false, null);
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)negativeRequirementForPatch);
        this.p1 = PatchTestUsingNegativeRequirement.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.c1, this.p1});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTestUsingNegativeRequirement.createPlanner();
        this.engine = PatchTestUsingNegativeRequirement.createEngine();
    }

    public void testInstall() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTestUsingNegativeRequirement.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        IQueryResult res = plan1.getAdditions().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor());
        PatchTestUsingNegativeRequirement.assertEquals((int)3, (int)res.toUnmodifiableSet().size());
        PatchTestUsingNegativeRequirement.assertContains(res, this.p1);
        PatchTestUsingNegativeRequirement.assertContains(res, this.a1);
        PatchTestUsingNegativeRequirement.assertContains(res, this.c1);
    }
}

