/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PermissiveSlicerTest
extends AbstractProvisioningTest {
    private IMetadataRepository repo;

    protected void setUp() throws Exception {
        super.setUp();
        File repoFile = PermissiveSlicerTest.getTestData("Repo for permissive slicer test", "testData/permissiveSlicer");
        this.repo = PermissiveSlicerTest.getMetadataRepositoryManager().loadRepository(repoFile.toURI(), (IProgressMonitor)new NullProgressMonitor());
    }

    public void testSliceRCPOut() {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, Collections.emptyMap(), true, false, true, false, false);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertNotNull((Object)result);
        PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()));
        PermissiveSlicerTest.assertEquals((int)66, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        PermissiveSlicerTest.assertEquals((int)1, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testSliceRCPWithOptionalPieces() {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, Collections.emptyMap(), false, false, true, false, false);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertNotNull((Object)result);
        PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()));
        PermissiveSlicerTest.assertEquals((int)64, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testSliceRCPWithIgnoringGreed() {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, Collections.emptyMap(), false, true, true, false, false);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertNotNull((Object)result);
        PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()));
        PermissiveSlicerTest.assertEquals((int)64, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testSliceRCPWithFilter() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("osgi.os", "win32");
        p.put("osgi.ws", "win32");
        p.put("osgi.arch", "x86");
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, p, true, true, false, false, false);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertNotNull((Object)result);
        PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()));
        PermissiveSlicerTest.assertEquals((int)0, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUQuery((String)"org.eclipse.swt.motif.linux.x86"), (IProgressMonitor)new NullProgressMonitor())));
        PermissiveSlicerTest.assertEquals((int)34, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testStrictDependency() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("osgi.os", "win32");
        p.put("osgi.ws", "win32");
        p.put("osgi.arch", "x86");
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, p, true, false, false, true, false);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertNotNull((Object)result);
        PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()));
        PermissiveSlicerTest.assertEquals((int)0, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUQuery((String)"org.eclipse.ecf"), (IProgressMonitor)new NullProgressMonitor())));
        PermissiveSlicerTest.assertEquals((int)29, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testExtractPlatformIndependentPieces() {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, Collections.emptyMap(), true, false, false, false, false);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryable result = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertNotNull((Object)result);
        PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()));
        PermissiveSlicerTest.assertEquals((int)32, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor())));
        PermissiveSlicerTest.assertEquals((int)1, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor())));
    }

    public void testMetaRequirements() {
        IProvidedCapability act1Cap = MetadataFactory.createProvidedCapability((String)"p2.action", (String)"action1", (Version)DEFAULT_VERSION);
        IInstallableUnit act1 = PermissiveSlicerTest.createIU("Action1", DEFAULT_VERSION, null, (IRequirement[])NO_REQUIRES, new IProvidedCapability[]{act1Cap}, NO_PROPERTIES, null, NO_TP_DATA, true);
        IRequirement[] metaReq = PermissiveSlicerTest.createRequiredCapabilities("p2.action", "action1", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit a = PermissiveSlicerTest.createIUWithMetaRequirement("A", DEFAULT_VERSION, true, (IRequirement[])NO_REQUIRES, metaReq);
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.createTestMetdataRepository(new IInstallableUnit[]{a, act1}), Collections.emptyMap(), true, false, false, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{a}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertEquals((int)1, (int)PermissiveSlicerTest.queryResultSize(result.query(QueryUtil.createIUQuery((String)"Action1"), null)));
    }

    public void testValidateIU() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("osgi.os", "win32");
        p.put("osgi.ws", "win32");
        p.put("osgi.arch", "x86");
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, p, true, false, false, true, false);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.swt.cocoa.macosx"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        PermissiveSlicerTest.assertNull((Object)slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor()));
        PermissiveSlicerTest.assertNotOK((IStatus)slicer.getStatus());
    }

    public void testMissingNecessaryPiece() {
        IRequirement[] req = PermissiveSlicerTest.createRequiredCapabilities("B", "B", new VersionRange("[0.0.0, 1.0.0]"));
        IInstallableUnit iuA = PermissiveSlicerTest.createIU("A", DEFAULT_VERSION, null, req, NO_PROVIDES, NO_PROPERTIES, null, NO_TP_DATA, true);
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.createTestMetdataRepository(new IInstallableUnit[]{iuA}), Collections.emptyMap(), true, false, false, false, false);
        IQueryable result = slicer.slice(new IInstallableUnit[]{iuA}, (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertNotNull((Object)result);
        PermissiveSlicerTest.assertNotOK((IStatus)slicer.getStatus());
    }

    public void testExtractOnlyPlatformSpecificForOnePlatform() {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("osgi.os", "win32");
        p.put("osgi.ws", "win32");
        p.put("osgi.arch", "x86");
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, p, true, false, false, false, true);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryResult resultCollector = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor()).query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertEquals((int)3, (int)PermissiveSlicerTest.queryResultSize(resultCollector));
    }

    public void testExtractOnlyPlatformSpecific() {
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)this.repo, Collections.emptyMap(), true, false, true, false, true);
        IQueryResult c = this.repo.query(QueryUtil.createIUQuery((String)"org.eclipse.rcp.feature.group"), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = (IInstallableUnit)c.iterator().next();
        IQueryResult resultCollector = slicer.slice(new IInstallableUnit[]{iu}, (IProgressMonitor)new NullProgressMonitor()).query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        PermissiveSlicerTest.assertEquals((int)35, (int)PermissiveSlicerTest.queryResultSize(resultCollector));
    }
}

