/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.ResolvedInstallableUnit;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvedIUInPCR
extends AbstractProvisioningTest {
    @IUDescription(content="package: iu1 \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit iu1;
    @IUDescription(content="package: iu2 \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit iu2;
    private IProfile profile;

    @Override
    protected void setUp() throws Exception {
        IULoader.loadIUs((Object)this);
        this.profile = this.createProfile("ResolvedIUInPCR." + this.getName());
    }

    public void testNoResolvedIUInAddition() {
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.add((IInstallableUnit)riu1);
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getAdditions(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getAdditions(), this.iu1));
    }

    public void testNoResolvedIUInBulkAddition() {
        ArrayList<ResolvedInstallableUnit> riusToAdd = new ArrayList<ResolvedInstallableUnit>();
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        riusToAdd.add(riu1);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addAll(riusToAdd);
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getAdditions(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getAdditions(), this.iu1));
    }

    public void testNoResolvedIUInBulkAddition2() {
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        ResolvedInstallableUnit riu2 = new ResolvedInstallableUnit(this.iu2);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.addInstallableUnits(new IInstallableUnit[]{riu1, riu2});
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getAdditions(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getAdditions(), (IInstallableUnit)riu2));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getAdditions(), this.iu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getAdditions(), this.iu2));
    }

    public void testNoResolvedIUInRemoval() {
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.remove((IInstallableUnit)riu1);
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getRemovals(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getRemovals(), this.iu1));
    }

    public void testNoResolvedIUInBulkRemoval() {
        ArrayList<ResolvedInstallableUnit> riusToAdd = new ArrayList<ResolvedInstallableUnit>();
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        riusToAdd.add(riu1);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.removeAll(riusToAdd);
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getRemovals(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getRemovals(), this.iu1));
    }

    public void testNoResolvedIUInBulkRemoval2() {
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        ResolvedInstallableUnit riu2 = new ResolvedInstallableUnit(this.iu2);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.removeInstallableUnits(new IInstallableUnit[]{riu1, riu2});
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getRemovals(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getRemovals(), (IInstallableUnit)riu2));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getRemovals(), this.iu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getRemovals(), this.iu2));
    }

    public void testNoResolvedIUInstallableUnitInclusionRules() {
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        ResolvedInstallableUnit riu2 = new ResolvedInstallableUnit(this.iu2);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.setInstallableUnitInclusionRules((IInstallableUnit)riu1, "inclusion");
        pcr.setInstallableUnitProfileProperty((IInstallableUnit)riu2, "a", "b");
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToAdd().keySet(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToAdd().keySet(), (IInstallableUnit)riu2));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToAdd().keySet(), this.iu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToAdd().keySet(), this.iu2));
    }

    public void testNoResolvedIUInstallableUnitInclusionRules2() {
        ResolvedInstallableUnit riu1 = new ResolvedInstallableUnit(this.iu1);
        ResolvedInstallableUnit riu2 = new ResolvedInstallableUnit(this.iu2);
        ProfileChangeRequest pcr = new ProfileChangeRequest(this.profile);
        pcr.removeInstallableUnitInclusionRules((IInstallableUnit)riu1);
        pcr.removeInstallableUnitProfileProperty((IInstallableUnit)riu2, "a");
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToRemove().keySet(), (IInstallableUnit)riu1));
        ResolvedIUInPCR.assertFalse((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToRemove().keySet(), (IInstallableUnit)riu2));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToRemove().keySet(), this.iu1));
        ResolvedIUInPCR.assertTrue((boolean)this.identityContains(pcr.getInstallableUnitProfilePropertiesToRemove().keySet(), this.iu2));
    }

    private boolean identityContains(Collection<IInstallableUnit> ius, IInstallableUnit match) {
        for (IInstallableUnit iu : ius) {
            if (iu != match) continue;
            return true;
        }
        return false;
    }
}

