/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SeveralOptionalDependencies4
extends AbstractProvisioningTest {
    private IInstallableUnit x1;
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit a2;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        IRequirement reqA = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true);
        IRequirement reqB = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true);
        this.x1 = SeveralOptionalDependencies4.createIU("X", Version.create((String)"1.0.0"), new IRequirement[]{reqA, reqB});
        this.a1 = SeveralOptionalDependencies4.createIU("A", Version.create((String)"1.0.0"), true);
        this.a2 = SeveralOptionalDependencies4.createIU("A", Version.create((String)"2.0.0"), true);
        this.b1 = SeveralOptionalDependencies4.createIU("B", Version.create((String)"1.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.x1, this.a1, this.b1, this.a2});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = SeveralOptionalDependencies4.createPlanner();
    }

    public void testInstallation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.x1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SeveralOptionalDependencies4.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        SeveralOptionalDependencies4.assertInstallOperand(plan, this.x1);
        SeveralOptionalDependencies4.assertInstallOperand(plan, this.b1);
        SeveralOptionalDependencies4.assertInstallOperand(plan, this.a2);
        SeveralOptionalDependencies4.assertNoOperand(plan, this.a1);
    }
}

