/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SeveralOptionalDependencies5
extends AbstractProvisioningTest {
    private IInstallableUnit x1;
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit c1;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        IRequirement reqA = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true);
        IRequirement reqC = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)true, (boolean)false, (boolean)true);
        IRequirement reqE = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"E", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)true, (boolean)false, (boolean)true);
        this.x1 = SeveralOptionalDependencies5.createIU("X", Version.create((String)"1.0.0"), new IRequirement[]{reqA, reqC, reqE});
        IRequirement reqB = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true);
        this.a1 = SeveralOptionalDependencies5.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{reqB});
        IRequirement reqD = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true);
        this.c1 = SeveralOptionalDependencies5.createIU("C", Version.create((String)"1.0.0"), new IRequirement[]{reqD});
        this.b1 = SeveralOptionalDependencies5.createIU("B", Version.create((String)"1.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.x1, this.a1, this.b1, this.c1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = SeveralOptionalDependencies5.createPlanner();
    }

    public void testInstallation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.x1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SeveralOptionalDependencies5.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        SeveralOptionalDependencies5.assertInstallOperand(plan, this.x1);
        SeveralOptionalDependencies5.assertInstallOperand(plan, this.a1);
        SeveralOptionalDependencies5.assertInstallOperand(plan, this.b1);
        SeveralOptionalDependencies5.assertNoOperand(plan, this.c1);
    }
}

