/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SimpleOptionalTest2
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit b2;
    private IInstallableUnit b3;
    private IInstallableUnit c1;
    private IInstallableUnit c2;
    private IInstallableUnit d1;
    private IInstallableUnit d2;
    private IInstallableUnit x1;
    private IInstallableUnit y1;
    private IInstallableUnit z1;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        this.b1 = SimpleOptionalTest2.createIU("B", Version.create((String)"1.0.0"), true);
        this.b2 = SimpleOptionalTest2.createIU("B", Version.create((String)"2.0.0"), true);
        this.b3 = SimpleOptionalTest2.createIU("B", Version.create((String)"3.0.0"), true);
        this.c1 = SimpleOptionalTest2.createIU("C", Version.create((String)"1.0.0"), true);
        this.c2 = SimpleOptionalTest2.createIU("C", Version.create((String)"2.0.0"), true);
        this.d1 = SimpleOptionalTest2.createIU("D", Version.create((String)"1.0.0"), true);
        this.d2 = SimpleOptionalTest2.createIU("D", Version.create((String)"2.0.0"), true);
        this.y1 = SimpleOptionalTest2.createIU("Y", Version.create((String)"1.0.0"), true);
        this.z1 = SimpleOptionalTest2.createIU("Z", Version.create((String)"1.0.0"), true);
        IRequirement[] reqA = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true)};
        this.a1 = SimpleOptionalTest2.createIU("A", Version.create((String)"1.0.0"), reqA);
        IRequirement[] req = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"D", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"Y", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"Z", (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)false, (boolean)true)};
        this.x1 = SimpleOptionalTest2.createIU("X", req);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.b3, this.c1, this.c2, this.d1, this.d2, this.x1, this.z1, this.y1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = SimpleOptionalTest2.createPlanner();
    }

    public void testInstallation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.x1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SimpleOptionalTest2.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        SimpleOptionalTest2.assertInstallOperand(plan, this.a1);
        SimpleOptionalTest2.assertInstallOperand(plan, this.c2);
        SimpleOptionalTest2.assertInstallOperand(plan, this.d1);
        SimpleOptionalTest2.assertInstallOperand(plan, this.y1);
        SimpleOptionalTest2.assertInstallOperand(plan, this.z1);
        SimpleOptionalTest2.assertInstallOperand(plan, this.x1);
    }
}

