/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SimpleOptionalTest4
extends AbstractProvisioningTest {
    private IInstallableUnit a1;
    private IInstallableUnit b1;
    private IInstallableUnit b2;
    private IInstallableUnit b3;
    private IInstallableUnit b4;
    private IProfile profile;
    private IPlanner planner;

    protected void setUp() throws Exception {
        super.setUp();
        this.b1 = SimpleOptionalTest4.createIU("B", Version.create((String)"1.0.0"), false);
        this.b2 = SimpleOptionalTest4.createIU("B", Version.create((String)"2.0.0"), false);
        this.b3 = SimpleOptionalTest4.createIU("B", Version.create((String)"3.0.0"), false);
        this.b4 = SimpleOptionalTest4.createIU("B", Version.create((String)"4.0.0"), false);
        IRequirement[] reqA = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0,1.0.0]"), null, (boolean)true, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[2.0.0,2.0.0]"), null, (boolean)true, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[3.0.0,3.0.0]"), null, (boolean)true, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[4.0.0,4.0.0]"), null, (boolean)true, (boolean)false, (boolean)true)};
        this.a1 = SimpleOptionalTest4.createIU("A", Version.create((String)"1.0.0"), reqA);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.b3, this.b4});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = SimpleOptionalTest4.createPlanner();
    }

    public void testInstallation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.b1});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SimpleOptionalTest4.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        SimpleOptionalTest4.assertInstallOperand(plan, this.a1);
        SimpleOptionalTest4.assertInstallOperand(plan, this.b1);
        SimpleOptionalTest4.assertInstallOperand(plan, this.b2);
        SimpleOptionalTest4.assertInstallOperand(plan, this.b3);
        SimpleOptionalTest4.assertInstallOperand(plan, this.b4);
    }
}

