/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SimpleSingleton
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IInstallableUnit a3;
    IInstallableUnit a4;
    IInstallableUnit u;
    IInstallableUnit v;
    IInstallableUnit w;
    IInstallableUnit x;
    IInstallableUnit y;
    IInstallableUnit z;
    IPlanner planner;
    IProfile profile;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = SimpleSingleton.createIU("A", Version.create((String)"1.0.0"), true);
        this.a2 = SimpleSingleton.createIU("A", Version.create((String)"2.0.0"), true);
        IRequirement c1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false);
        IRequirement c2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)new VersionRange("[2.0.0, 2.0.0]"), null, (boolean)false, (boolean)false);
        this.y = SimpleSingleton.createIU("Y", Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{c1, c2});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a2, this.y});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = SimpleSingleton.createPlanner();
    }

    public void test1() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.y});
        ProvisioningPlan provisioningPlan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SimpleSingleton.assertEquals((int)4, (int)provisioningPlan.getStatus().getSeverity());
        SimpleSingleton.assertNull((Object)provisioningPlan.getFutureState());
        SimpleSingleton.assertNotNull((Object)((PlannerStatus)provisioningPlan.getStatus()).getPlannedState());
    }

    public void testExplanation() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.y});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SimpleSingleton.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        SimpleSingleton.assertEquals((int)2, (int)requestStatus.getShortExplanation());
        SimpleSingleton.assertTrue((boolean)requestStatus.getConflictsWithInstalledRoots().contains(this.y));
    }
}

