/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SimulatedSharedInstallTest
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit c1;
    IPlanner planner;
    IProfile profile;
    IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = SimulatedSharedInstallTest.createIU("A", Version.parseVersion((String)"1.0.0"), SimulatedSharedInstallTest.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[1.0.0, 1.0.0]")));
        this.b1 = SimulatedSharedInstallTest.createIU("B", Version.parseVersion((String)"1.0.0"));
        this.c1 = SimulatedSharedInstallTest.createIU("C", Version.parseVersion((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)true, (boolean)false)});
        this.profile = this.createProfile(SimulatedSharedInstallTest.class.getName());
        this.planner = SimulatedSharedInstallTest.createPlanner();
        this.engine = SimulatedSharedInstallTest.createEngine();
    }

    public void testRemoveUnresolvedIU() {
        ProvisioningContext context = new ProvisioningContext(SimulatedSharedInstallTest.getAgent());
        IProvisioningPlan plan = this.engine.createPlan(this.profile, context);
        plan.addInstallableUnit(this.a1);
        plan.setInstallableUnitProfileProperty(this.a1, "org.eclipse.equinox.p2.internal.inclusion.rules", ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.a1));
        context.setMetadataRepositories(new URI[0]);
        SimulatedSharedInstallTest.assertEquals((int)0, (int)this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor()).getSeverity());
        SimulatedSharedInstallTest.assertContains(this.profile.query(QueryUtil.createIUAnyQuery(), null), this.a1);
        IProvisioningPlan plan2 = this.engine.createPlan(this.profile, context);
        plan2.removeInstallableUnit(this.a1);
        SimulatedSharedInstallTest.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        SimulatedSharedInstallTest.assertEquals((int)0, (int)PlanExecutionHelper.executePlan((IProvisioningPlan)plan2, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor()).getSeverity());
        SimulatedSharedInstallTest.assertNotContains(this.profile.query(QueryUtil.createIUAnyQuery(), null), this.a1);
    }

    public void testAvailableVsQueryInProfile() {
        ProvisioningContext context = new ProvisioningContext(SimulatedSharedInstallTest.getAgent());
        IProvisioningPlan plan = this.engine.createPlan(this.profile, context);
        plan.addInstallableUnit(this.c1);
        plan.setInstallableUnitProfileProperty(this.c1, "org.eclipse.equinox.p2.internal.inclusion.rules", ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.c1));
        context.setMetadataRepositories(new URI[0]);
        SimulatedSharedInstallTest.assertEquals((int)0, (int)this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor()).getSeverity());
        SimulatedSharedInstallTest.assertContains(this.profile.query(QueryUtil.createIUAnyQuery(), null), this.c1);
        IProfile availableWrapper = new IProfile(){

            public IQueryResult<IInstallableUnit> available(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                IQueryResult queryResult = SimulatedSharedInstallTest.this.profile.query(query, monitor);
                Collector collector = new Collector();
                collector.addAll(queryResult);
                ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
                ius.add(SimulatedSharedInstallTest.this.b1);
                collector.addAll(query.perform(ius.iterator()));
                return collector;
            }

            public Map getInstallableUnitProperties(IInstallableUnit iu) {
                return SimulatedSharedInstallTest.this.profile.getInstallableUnitProperties(iu);
            }

            public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
                return SimulatedSharedInstallTest.this.profile.getInstallableUnitProperty(iu, key);
            }

            public String getProfileId() {
                return SimulatedSharedInstallTest.this.profile.getProfileId();
            }

            public Map getProperties() {
                return SimulatedSharedInstallTest.this.profile.getProperties();
            }

            public String getProperty(String key) {
                return SimulatedSharedInstallTest.this.profile.getProperty(key);
            }

            public long getTimestamp() {
                return SimulatedSharedInstallTest.this.profile.getTimestamp();
            }

            public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                return SimulatedSharedInstallTest.this.profile.query(query, monitor);
            }

            public IProvisioningAgent getProvisioningAgent() {
                return SimulatedSharedInstallTest.this.profile.getProvisioningAgent();
            }
        };
        ProfileChangeRequest req = new ProfileChangeRequest(availableWrapper);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        SimulatedSharedInstallTest.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        SimulatedSharedInstallTest.assertEquals((int)2, (int)this.countPlanElements(plan2));
    }
}

