/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SingletonOptionallyInstalled2
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit a2;
    IPlanner planner;
    IProfile profile;
    private IEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = SingletonOptionallyInstalled2.createIU("A", Version.create((String)"1.0.0"), true);
        this.a2 = SingletonOptionallyInstalled2.createIU("A", Version.create((String)"2.0.0"), true);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.a2});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = SingletonOptionallyInstalled2.createPlanner();
        this.engine = SingletonOptionallyInstalled2.createEngine();
    }

    public void test2() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.a1, this.a2});
        req.setInstallableUnitInclusionRules(this.a1, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a1));
        req.setInstallableUnitInclusionRules(this.a2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a2));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        this.engine.perform(plan, (IProgressMonitor)new NullProgressMonitor());
        SingletonOptionallyInstalled2.assertProfileContains("foo", this.profile, new IInstallableUnit[]{this.a2});
        ProfileChangeRequest req4 = new ProfileChangeRequest(this.profile);
        req4.addInstallableUnits(new IInstallableUnit[]{this.a2});
        req4.setInstallableUnitInclusionRules(this.a2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.a2));
        IProvisioningPlan plan4 = this.planner.getProvisioningPlan((IProfileChangeRequest)req4, null, null);
        this.engine.perform(plan4, (IProgressMonitor)new NullProgressMonitor());
        SingletonOptionallyInstalled2.assertProfileContains("foo", this.profile, new IInstallableUnit[]{this.a2});
    }
}

