/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class TestFilteringOnAbsentProperty
extends AbstractProvisioningTest {
    private static final String NS = "org.eclipse.equinox.p2.iu";
    private static final String N = "theName";
    private IInstallableUnit iuA;
    private IInstallableUnit iuABundled;
    private IInstallableUnit iuTop;

    protected void setUp() throws Exception {
        MetadataFactory.InstallableUnitDescription desc_iuA = new MetadataFactory.InstallableUnitDescription();
        desc_iuA.setId(N);
        desc_iuA.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities = new ArrayList<IProvidedCapability>();
        capabilities.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        desc_iuA.addProvidedCapabilities(capabilities);
        desc_iuA.setFilter("(&(osgi.os=macosx) (!(macosx-bundled=*)) )");
        this.iuA = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc_iuA);
        MetadataFactory.InstallableUnitDescription desc_iuA_bundled = new MetadataFactory.InstallableUnitDescription();
        desc_iuA_bundled.setId("A-bundled");
        desc_iuA_bundled.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilities2 = new ArrayList<IProvidedCapability>();
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)"A-bundled", (Version)Version.create((String)"1.0.0")));
        capabilities2.add(MetadataFactory.createProvidedCapability((String)NS, (String)N, (Version)Version.create((String)"1.0.0")));
        desc_iuA_bundled.addProvidedCapabilities(capabilities2);
        desc_iuA_bundled.setFilter("(&(osgi.os=macosx) (macosx-bundled=true))");
        this.iuABundled = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc_iuA_bundled);
        MetadataFactory.InstallableUnitDescription desc_top = new MetadataFactory.InstallableUnitDescription();
        desc_top.setId("Top");
        desc_top.setVersion(Version.create((String)"1.0.0"));
        ArrayList<IProvidedCapability> capabilitiesTop = new ArrayList<IProvidedCapability>();
        capabilitiesTop.add(MetadataFactory.createProvidedCapability((String)NS, (String)"Top", (Version)Version.create((String)"1.0.0")));
        desc_top.addProvidedCapabilities(capabilitiesTop);
        desc_top.setRequirements(new IRequirement[]{MetadataFactory.createRequirement((String)NS, (String)N, (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.iuTop = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc_top);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.iuA, this.iuABundled, this.iuTop});
    }

    public void testWithBundledProperty() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osgi.os", "macosx");
        properties.put("macosx-bundled", "true");
        IProfile profile = this.createProfile("TestProfile." + this.getName(), properties);
        IPlanner planner = TestFilteringOnAbsentProperty.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
        changeRequest.add(this.iuTop);
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, null);
        IQueryResult futureIUs = plan.getFutureState().query(QueryUtil.ALL_UNITS, null);
        TestFilteringOnAbsentProperty.assertEquals((int)2, (int)futureIUs.toUnmodifiableSet().size());
        TestFilteringOnAbsentProperty.assertContains(futureIUs, this.iuTop);
        TestFilteringOnAbsentProperty.assertContains(futureIUs, this.iuABundled);
    }

    public void testWithoutBundledProperty() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osgi.os", "macosx");
        IProfile profile = this.createProfile("TestProfile." + this.getName(), properties);
        IPlanner planner = TestFilteringOnAbsentProperty.createPlanner();
        ProfileChangeRequest changeRequest = new ProfileChangeRequest(profile);
        changeRequest.add(this.iuTop);
        ProvisioningPlan plan = (ProvisioningPlan)planner.getProvisioningPlan((IProfileChangeRequest)changeRequest, null, null);
        IQueryResult futureIUs = plan.getFutureState().query(QueryUtil.ALL_UNITS, null);
        TestFilteringOnAbsentProperty.assertEquals((int)2, (int)futureIUs.toUnmodifiableSet().size());
        TestFilteringOnAbsentProperty.assertContains(futureIUs, this.iuTop);
        TestFilteringOnAbsentProperty.assertContains(futureIUs, this.iuA);
    }
}

