/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerOneInstalledOneBeingInstalled
extends AbstractProvisioningTest {
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit egit1;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit egit2;
    @IUDescription(content="package: svn1 \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit svn1;
    @IUDescription(content="package: svn2 \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit svn2;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private IProfileChangeRequest originalRequest;
    private ProvisioningContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile("TestProfile." + this.getName());
        IULoader.loadIUs((Object)this);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2});
        this.planner = TestRequestFlexerOneInstalledOneBeingInstalled.createPlanner();
        this.engine = TestRequestFlexerOneInstalledOneBeingInstalled.createEngine();
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.install(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        this.originalRequest = this.planner.createChangeRequest(this.profile);
        this.originalRequest.add(this.egit2);
        this.originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertNotOK(this.planner.getProvisioningPlan(this.originalRequest, this.context, null).getStatus());
        IProfileChangeRequest validateGoalRequest = this.planner.createChangeRequest(this.profile);
        validateGoalRequest.add(this.egit2);
        validateGoalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        validateGoalRequest.add(this.sdk2);
        validateGoalRequest.setInstallableUnitInclusionRules(this.sdk2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.sdk2));
        validateGoalRequest.remove(this.sdk1);
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.planner.getProvisioningPlan(validateGoalRequest, this.context, null).getStatus());
        validateGoalRequest = this.planner.createChangeRequest(this.profile);
        validateGoalRequest.add(this.egit1);
        validateGoalRequest.setInstallableUnitInclusionRules(this.egit1, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit1));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.planner.getProvisioningPlan(validateGoalRequest, this.context, null).getStatus());
        this.context = new ProvisioningContext(TestRequestFlexerOneInstalledOneBeingInstalled.getAgent());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.getProfileRegistry().removeProfile(this.profile.getProfileId());
    }

    public void testInstallAnotherVersion() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowDifferentVersion(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.egit1));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertEquals((int)1, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getRemovals().isEmpty());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.install(realRequest, this.planner, this.engine));
    }

    public void testInstallPartial() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertNull((Object)realRequest);
    }

    public void testInstallSomeElementsWithUpdates() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(true);
        av.setAllowDifferentVersion(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.egit1));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertEquals((int)1, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getRemovals().isEmpty());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.install(realRequest, this.planner, this.engine));
    }

    public void testUpdateBase() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertEquals((int)2, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertEquals((int)1, (int)realRequest.getRemovals().size());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.install(realRequest, this.planner, this.engine));
    }

    public void testRemoveBase() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementRemoval(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.install(realRequest, this.planner, this.engine));
    }

    public void testAllowEverything() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(true);
        av.setAllowDifferentVersion(true);
        av.setAllowInstalledElementRemoval(true);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        TestRequestFlexerOneInstalledOneBeingInstalled.assertOK(this.install(realRequest, this.planner, this.engine));
    }

    public void testDoNothing() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledOneBeingInstalled.assertNull((Object)realRequest);
    }
}

