/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerOneInstalledTwoBeingInstalled
extends AbstractProvisioningTest {
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit egit1;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit egit2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 3 \ndepends: platform = 3")
    public IInstallableUnit egit3;
    @IUDescription(content="package: svn \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit svn1;
    @IUDescription(content="package: svn \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit svn2;
    @IUDescription(content="package: svn \nsingleton: true\nversion: 3 \ndepends: platform = 3")
    public IInstallableUnit svn3;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private ProvisioningContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile("TestProfile." + this.getName());
        IULoader.loadIUs((Object)this);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1});
        this.planner = TestRequestFlexerOneInstalledTwoBeingInstalled.createPlanner();
        this.engine = TestRequestFlexerOneInstalledTwoBeingInstalled.createEngine();
        this.context = new ProvisioningContext(TestRequestFlexerOneInstalledTwoBeingInstalled.getAgent());
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertOK(this.install(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
    }

    public void testAssumptions() {
        IProfileChangeRequest originalRequest = this.planner.createChangeRequest(this.profile);
        originalRequest.add(this.egit2);
        originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        originalRequest.add(this.svn1);
        originalRequest.setInstallableUnitInclusionRules(this.svn1, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.svn1));
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertNotOK(this.planner.getProvisioningPlan(originalRequest, this.context, null).getStatus());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.getProfileRegistry().removeProfile(this.profile.getProfileId());
    }

    public void testConflictWithTheBase() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2, this.egit3, this.svn1, this.svn2, this.svn3});
        IProfileChangeRequest originalRequest = this.planner.createChangeRequest(this.profile);
        originalRequest.add(this.egit2);
        originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        originalRequest.add(this.svn1);
        originalRequest.setInstallableUnitInclusionRules(this.svn1, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.svn1));
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowDifferentVersion(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.egit1));
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.svn1));
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertEquals((int)2, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getRemovals().isEmpty());
        this.assertResolve(realRequest, this.planner);
        av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(true);
        av.setProvisioningContext(this.context);
        realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.svn1));
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertEquals((int)1, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getRemovals().isEmpty());
        av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementChange(true);
        av.setAllowDifferentVersion(true);
        av.setProvisioningContext(this.context);
        realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.svn2));
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getAdditions().contains(this.svn2));
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertEquals((int)3, (int)realRequest.getAdditions().size());
        TestRequestFlexerOneInstalledTwoBeingInstalled.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
    }
}

