/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerRequestWithOptionalInstall
extends AbstractProvisioningTest {
    final String INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    final String INCLUSION_OPTIONAL = "OPTIONAL";
    final String INCLUSION_STRICT = "STRICT";
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit egit1;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit egit2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 3 \ndepends: platform = 3")
    public IInstallableUnit egit3;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private ProvisioningContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile("TestProfile." + this.getName());
        IULoader.loadIUs((Object)this);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1});
        this.planner = TestRequestFlexerRequestWithOptionalInstall.createPlanner();
        this.engine = TestRequestFlexerRequestWithOptionalInstall.createEngine();
        this.context = new ProvisioningContext(TestRequestFlexerRequestWithOptionalInstall.getAgent());
        TestRequestFlexerRequestWithOptionalInstall.assertOK(this.installAsRoots(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
    }

    public void testWithOptionalInstall() {
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2, this.egit3});
        IProfileChangeRequest originalRequest = this.planner.createChangeRequest(this.profile);
        originalRequest.add(this.egit2);
        originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.egit2));
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerRequestWithOptionalInstall.assertNull((Object)realRequest);
        av = new RequestFlexer(this.planner);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerRequestWithOptionalInstall.assertTrue((boolean)realRequest.getAdditions().contains(this.egit2));
        TestRequestFlexerRequestWithOptionalInstall.assertTrue((boolean)realRequest.getAdditions().contains(this.sdk2));
        TestRequestFlexerRequestWithOptionalInstall.assertEquals((int)2, (int)realRequest.getAdditions().size());
        TestRequestFlexerRequestWithOptionalInstall.assertTrue((boolean)realRequest.getRemovals().contains(this.sdk1));
        this.assertResolve(realRequest, this.planner);
        av = new RequestFlexer(this.planner);
        av.setAllowDifferentVersion(true);
        av.setProvisioningContext(this.context);
        realRequest = av.getChangeRequest(originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerRequestWithOptionalInstall.assertTrue((boolean)realRequest.getAdditions().contains(this.egit1));
        TestRequestFlexerRequestWithOptionalInstall.assertEquals((int)1, (int)realRequest.getAdditions().size());
        TestRequestFlexerRequestWithOptionalInstall.assertTrue((boolean)this.isOptionallyBeingInstalled(this.egit1, realRequest));
        this.assertResolve(realRequest, this.planner);
    }

    private boolean isOptionallyBeingInstalled(IInstallableUnit iu, IProfileChangeRequest originalRequest) {
        Map match = (Map)((ProfileChangeRequest)originalRequest).getInstallableUnitProfilePropertiesToAdd().get(iu);
        if (match == null) {
            return false;
        }
        return "OPTIONAL".equals(match.get("org.eclipse.equinox.p2.internal.inclusion.rules"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.getProfileRegistry().removeProfile(this.profile.getProfileId());
    }
}

