/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.operations.RequestFlexer;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class TestRequestFlexerSharedInstall
extends AbstractProvisioningTest {
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit sdk1;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit platform1;
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit sdk2;
    @IUDescription(content="package: platform \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit platform2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit egit1;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit egit2;
    @IUDescription(content="package: svn1 \nsingleton: true\nversion: 1 \ndepends: platform = 1")
    public IInstallableUnit svn1;
    @IUDescription(content="package: svn2 \nsingleton: true\nversion: 2 \ndepends: platform = 2")
    public IInstallableUnit svn2;
    IProfile profile;
    private IPlanner planner;
    private IEngine engine;
    private IProfileChangeRequest originalRequest;
    private ProvisioningContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.profile = this.createProfile("TestProfile." + this.getName());
        IULoader.loadIUs((Object)this);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.platform1, this.sdk2, this.platform2, this.egit1, this.egit2});
        this.planner = TestRequestFlexerSharedInstall.createPlanner();
        this.engine = TestRequestFlexerSharedInstall.createEngine();
        TestRequestFlexerSharedInstall.assertOK(this.installAsRootsAndFlaggedAsBase(this.profile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        this.originalRequest = this.planner.createChangeRequest(this.profile);
        this.originalRequest.add(this.egit2);
        this.originalRequest.setInstallableUnitInclusionRules(this.egit2, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.egit2));
        TestRequestFlexerSharedInstall.assertNotOK(this.planner.getProvisioningPlan(this.originalRequest, this.context, null).getStatus());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.getProfileRegistry().removeProfile(this.profile.getProfileId());
    }

    public void testBaseBlocked() {
        RequestFlexer av = new RequestFlexer(this.planner);
        av.setAllowPartialInstall(false);
        av.setAllowDifferentVersion(false);
        av.setAllowInstalledElementRemoval(true);
        av.setAllowInstalledElementChange(true);
        av.setProvisioningContext(this.context);
        IProfileChangeRequest realRequest = av.getChangeRequest(this.originalRequest, this.profile, (IProgressMonitor)new NullProgressMonitor());
        TestRequestFlexerSharedInstall.assertNull((Object)realRequest);
    }
}

