/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher;

import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.p2.publisher.QuotedTokenizer;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAndBundlesPublisherApplication;
import org.eclipse.equinox.p2.tests.StringBufferStream;

public class GeneralPublisherTests
extends TestCase {
    public void testBug255820_Product_normalize() throws Exception {
        Method normalizeMethod = ProductFile.class.getDeclaredMethod("normalize", String.class);
        normalizeMethod.setAccessible(true);
        GeneralPublisherTests.assertNotNull((Object)normalizeMethod);
        GeneralPublisherTests.assertEquals((Object)normalizeMethod.invoke(null, "a b  c\td\ne"), (Object)"a b c d e");
        GeneralPublisherTests.assertEquals((Object)normalizeMethod.invoke(null, "a\fbd\r\n e"), (Object)"a bd e");
    }

    public void testInvalidConfiguration1() {
        StringBuffer buffer;
        Integer retValue;
        FeaturesAndBundlesPublisherApplication application;
        block5: {
            application = new FeaturesAndBundlesPublisherApplication();
            retValue = 0;
            buffer = new StringBuffer();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    retValue = (Integer)application.run(new String[0]);
                }
                catch (Exception exception) {
                    GeneralPublisherTests.fail((String)"0.99");
                    System.setOut(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        GeneralPublisherTests.assertTrue((boolean)buffer.toString().contains("A metadata repository must be specified."));
        GeneralPublisherTests.assertEquals((String)"1.0", (int)1, (int)retValue);
        GeneralPublisherTests.assertEquals((String)"1.1", (String)Messages.exception_noMetadataRepo, (String)application.getStatus().getMessage());
    }

    public void testInvalidConfiguration2() {
        StringBuffer buffer;
        Integer retValue;
        FeaturesAndBundlesPublisherApplication application;
        block5: {
            application = new FeaturesAndBundlesPublisherApplication();
            retValue = 0;
            buffer = new StringBuffer();
            PrintStream out = System.out;
            try {
                try {
                    System.setOut(new PrintStream(new StringBufferStream(buffer)));
                    retValue = (Integer)application.run(new String[]{"-metadataRepository foo", "-publishArtifacts"});
                }
                catch (Exception exception) {
                    GeneralPublisherTests.fail((String)"0.99");
                    System.setOut(out);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                System.setOut(out);
                throw throwable;
            }
            System.setOut(out);
        }
        GeneralPublisherTests.assertTrue((boolean)buffer.toString().contains("An artifact repository must be specified in order to publish artifacts."));
        GeneralPublisherTests.assertEquals((String)"1.0", (int)1, (int)retValue);
        GeneralPublisherTests.assertEquals((String)"1.1", (String)Messages.exception_noArtifactRepo, (String)application.getStatus().getMessage());
    }

    public void testQuotedTokenizer() throws Exception {
        QuotedTokenizer tokenizer = new QuotedTokenizer("abra ca dabra");
        GeneralPublisherTests.assertEquals((String)"abra", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"ca", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertTrue((boolean)tokenizer.hasMoreTokens());
        GeneralPublisherTests.assertEquals((String)"dabra", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertFalse((boolean)tokenizer.hasMoreTokens());
        boolean exception = false;
        try {
            tokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            exception = true;
        }
        GeneralPublisherTests.assertTrue((boolean)exception);
        tokenizer = new QuotedTokenizer("ab c\"de fg\" hi");
        GeneralPublisherTests.assertEquals((String)"ab", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"cde fg", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"hi", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer("a,b c,d", ",");
        GeneralPublisherTests.assertEquals((String)"a", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"b c", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"d", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer("a bcd\u7432e fg");
        GeneralPublisherTests.assertEquals((String)"a", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"bcd\u7432e", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"fg", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer("    ");
        GeneralPublisherTests.assertFalse((boolean)tokenizer.hasMoreTokens());
        tokenizer = new QuotedTokenizer(",,,", ",");
        GeneralPublisherTests.assertFalse((boolean)tokenizer.hasMoreElements());
        tokenizer = new QuotedTokenizer("a \"b\\\" c\" d");
        GeneralPublisherTests.assertEquals((String)"a", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"b\" c", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertEquals((String)"d", (String)tokenizer.nextToken());
        GeneralPublisherTests.assertFalse((boolean)tokenizer.hasMoreTokens());
    }
}

