/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import org.eclipse.equinox.internal.p2.updatesite.CategoryPublisherApplication;
import org.eclipse.equinox.p2.publisher.AbstractPublisherApplication;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestData;

public class CategoryPublisherTest
extends AbstractProvisioningTest {
    protected StringBuffer runPublisherApp(AbstractPublisherApplication application, String[] args) throws Exception {
        PrintStream out = System.out;
        StringBuffer buffer = new StringBuffer();
        try {
            System.setOut(new PrintStream(new StringBufferStream(buffer)));
            application.run(args);
        }
        finally {
            System.setOut(out);
        }
        return buffer;
    }

    public void testCompressCategoryRepo() throws Exception {
        File repository = null;
        try {
            repository = this.getTempFolder();
            URI repositoryURI = repository.toURI();
            URI category1 = TestData.getFile("CategoryPublisherTests", "category1.xml").toURI();
            String[] firstRun = new String[]{"-metadataRepository", repositoryURI.toString(), "-categoryDefinition", category1.toString(), "-categoryQualifier", "foo"};
            String[] secondRun = new String[]{"-metadataRepository", repositoryURI.toString(), "-categoryDefinition", category1.toString(), "-categoryQualifier", "foo", "-compress"};
            CategoryPublisherApplication categoryPublisherApplication = new CategoryPublisherApplication();
            this.runPublisherApp((AbstractPublisherApplication)categoryPublisherApplication, firstRun);
            categoryPublisherApplication = new CategoryPublisherApplication();
            this.runPublisherApp((AbstractPublisherApplication)categoryPublisherApplication, secondRun);
            this.assertContains(repository, "content.jar");
        }
        catch (Throwable throwable) {
            if (repository != null & repository.exists()) {
                CategoryPublisherTest.delete(repository);
            }
            throw throwable;
        }
        if (repository != null & repository.exists()) {
            CategoryPublisherTest.delete(repository);
        }
    }

    public void testRememberRepoShapeJar() throws Exception {
        File repository = null;
        try {
            repository = this.getTempFolder();
            URI repositoryURI = repository.toURI();
            URI category1 = TestData.getFile("CategoryPublisherTests", "category1.xml").toURI();
            String[] firstRun = new String[]{"-metadataRepository", repositoryURI.toString(), "-categoryDefinition", category1.toString(), "-categoryQualifier", "foo", "-compress"};
            String[] secondRun = new String[]{"-metadataRepository", repositoryURI.toString(), "-categoryDefinition", category1.toString(), "-categoryQualifier", "foo"};
            CategoryPublisherApplication categoryPublisherApplication = new CategoryPublisherApplication();
            this.runPublisherApp((AbstractPublisherApplication)categoryPublisherApplication, firstRun);
            categoryPublisherApplication = new CategoryPublisherApplication();
            this.runPublisherApp((AbstractPublisherApplication)categoryPublisherApplication, secondRun);
            this.assertContains(repository, "content.jar");
        }
        catch (Throwable throwable) {
            if (repository != null & repository.exists()) {
                CategoryPublisherTest.delete(repository);
            }
            throw throwable;
        }
        if (repository != null & repository.exists()) {
            CategoryPublisherTest.delete(repository);
        }
    }

    public void testRememberRepoShapeXML() throws Exception {
        File repository = null;
        try {
            repository = this.getTempFolder();
            URI repositoryURI = repository.toURI();
            URI category1 = TestData.getFile("CategoryPublisherTests", "category1.xml").toURI();
            String[] firstRun = new String[]{"-metadataRepository", repositoryURI.toString(), "-categoryDefinition", category1.toString(), "-categoryQualifier", "foo"};
            String[] secondRun = new String[]{"-metadataRepository", repositoryURI.toString(), "-categoryDefinition", category1.toString(), "-categoryQualifier", "foo"};
            CategoryPublisherApplication categoryPublisherApplication = new CategoryPublisherApplication();
            this.runPublisherApp((AbstractPublisherApplication)categoryPublisherApplication, firstRun);
            categoryPublisherApplication = new CategoryPublisherApplication();
            this.runPublisherApp((AbstractPublisherApplication)categoryPublisherApplication, secondRun);
            this.assertContains(repository, "content.xml");
        }
        catch (Throwable throwable) {
            if (repository != null & repository.exists()) {
                CategoryPublisherTest.delete(repository);
            }
            throw throwable;
        }
        if (repository != null & repository.exists()) {
            CategoryPublisherTest.delete(repository);
        }
    }

    public void assertContains(File directory, String file) {
        CategoryPublisherTest.assertNotNull((Object)directory);
        CategoryPublisherTest.assertTrue((boolean)directory.exists());
        CategoryPublisherTest.assertTrue((boolean)directory.isDirectory());
        File[] listFiles = directory.listFiles();
        int i = 0;
        while (i < listFiles.length) {
            if (listFiles[i].getName().equals(file)) {
                return;
            }
            ++i;
        }
        CategoryPublisherTest.fail((String)("Directory does not contain file: " + file));
    }
}

