/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.eclipse.EquinoxExecutableAction;
import org.eclipse.equinox.p2.publisher.eclipse.IBrandingAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;

public class EquinoxExecutableActionTest
extends ActionTest {
    private static final File MAC_EXEC = new File(TestActivator.getTestDataFolder(), "EquinoxExecutableActionTest/macosx/");
    private static final File LINUX_EXEC = new File(TestActivator.getTestDataFolder(), "EquinoxExecutableActionTest/linux/");
    private static final File WIN_EXEC = new File(TestActivator.getTestDataFolder(), "EquinoxExecutableActionTest/win/");
    private final String EXECUTABLE_NAME = "LauncherName";
    private Collection<IBrandingAdvice> brandingAdvice = new LinkedList<IBrandingAdvice>();
    private String macConfig = "carbon.macosx.ppc";
    private String macConfigCocoa = "cocoa.macosx.x86";
    private String winConfig = "win32.win32.x86";
    private String linuxConfig = "linux.gtk.x86";
    private ExecutablesDescriptor executablesDescriptor;
    private IArtifactRepository artifactRepository;
    private Version version = Version.create((String)"1.2.3");
    private String id;
    private String[] expectedExecutablesContents;

    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    private void setupArtifactRepository() {
        this.artifactRepository = new TestArtifactRepository(EquinoxExecutableActionTest.getAgent());
    }

    public void testMacCarbon() throws Exception {
        File icon = File.createTempFile("LauncherName", ".icns");
        FileUtils.copyStream((InputStream)new FileInputStream(new File(MAC_EXEC, "eclipse.app/Contents/Resources/eclipse.icns")), (boolean)true, (OutputStream)new FileOutputStream(icon), (boolean)true);
        this.expectedExecutablesContents = new String[]{"LauncherName.app", "LauncherName.app/Contents/Info.plist", "LauncherName.app/Contents/MacOS/LauncherName", "LauncherName.app/Contents/MacOS/LauncherName.ini", "LauncherName.app/Contents/Resources/" + icon.getName()};
        this.testExecutableAction("mac", "macosx", this.macConfig, MAC_EXEC, icon);
    }

    public void testMacCocoa() throws Exception {
        File icon = File.createTempFile("LauncherName", ".icns");
        FileUtils.copyStream((InputStream)new FileInputStream(new File(MAC_EXEC, "eclipse.app/Contents/Resources/eclipse.icns")), (boolean)true, (OutputStream)new FileOutputStream(icon), (boolean)true);
        this.expectedExecutablesContents = new String[]{"LauncherName.app", "LauncherName.app/Contents/Info.plist", "LauncherName.app/Contents/MacOS/LauncherName", "LauncherName.app/Contents/MacOS/LauncherName.ini", "LauncherName.app/Contents/Resources/" + icon.getName()};
        this.testExecutableAction("macCocoa", "macosx", this.macConfigCocoa, MAC_EXEC, icon);
    }

    public void testWin() throws Exception {
        File icon = File.createTempFile("LauncherName", ".ico");
        FileUtils.copyStream((InputStream)new FileInputStream(new File(WIN_EXEC, "eclipse.ico")), (boolean)true, (OutputStream)new FileOutputStream(icon), (boolean)true);
        this.expectedExecutablesContents = new String[]{"LauncherName.exe"};
        this.testExecutableAction("win", "win32", this.winConfig, WIN_EXEC, icon);
    }

    public void testLinux() throws Exception {
        File icon = File.createTempFile("LauncherName", ".xpm");
        FileUtils.copyStream((InputStream)new FileInputStream(new File(LINUX_EXEC, "eclipse.xpm")), (boolean)true, (OutputStream)new FileOutputStream(icon), (boolean)true);
        this.expectedExecutablesContents = new String[]{"LauncherName", "icon.xpm"};
        this.testExecutableAction("linux", "linux", this.linuxConfig, LINUX_EXEC, icon);
    }

    private void testExecutableAction(String idBase, String osArg, String config, File exec, File icon) {
        this.id = idBase;
        this.setupBrandingAdvice(osArg, this.configSpec, exec, icon);
        this.executablesDescriptor = ExecutablesDescriptor.createDescriptor((String)osArg, (String)"eclipse", (File)exec);
        this.testAction = new EquinoxExecutableAction(this.executablesDescriptor, config, idBase, this.version, this.flavorArg);
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        this.verifyResults(idBase, config);
        this.debug("Completed EquinoxExecutableActionTest " + idBase + " test.");
    }

    private void verifyResults(String idBase, String confSpec) {
        ArrayList iuList = new ArrayList(this.publisherResult.getIUs(null, "root"));
        this.verifyExecIU(iuList, idBase, confSpec);
        this.verifyEclipseIU(iuList, idBase, confSpec);
        this.verifyCU(iuList, idBase, confSpec);
        if (confSpec.contains("macosx")) {
            EquinoxExecutableActionTest.assertTrue((iuList.size() == 4 ? 1 : 0) != 0);
        } else {
            EquinoxExecutableActionTest.assertTrue((iuList.size() == 3 ? 1 : 0) != 0);
        }
    }

    private void verifyCU(ArrayList iuList, String idBase, String confSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec((String)confSpec);
        String _ws = config[0];
        String _os = config[1];
        String _arch = config[2];
        int i = 0;
        while (i < iuList.size()) {
            IInstallableUnit possibleEclipse = (IInstallableUnit)iuList.get(i);
            if (possibleEclipse.getId().equals(String.valueOf(this.flavorArg) + idBase + ".executable." + confSpec)) {
                IInstallableUnitFragment fragment = (IInstallableUnitFragment)iuList.get(i);
                Collection providedCapability = fragment.getProvidedCapabilities();
                this.verifyProvidedCapability(providedCapability, "org.eclipse.equinox.p2.iu", String.valueOf(this.flavorArg) + idBase + ".executable." + confSpec, this.version);
                EquinoxExecutableActionTest.assertTrue((providedCapability.size() == 1 ? 1 : 0) != 0);
                Collection requiredCapability = fragment.getHost();
                this.verifyRequiredCapability(requiredCapability, "org.eclipse.equinox.p2.iu", String.valueOf(idBase) + ".executable." + confSpec, new VersionRange(this.version, true, this.version, true));
                EquinoxExecutableActionTest.assertTrue((requiredCapability.size() == 1 ? 1 : 0) != 0);
                EquinoxExecutableActionTest.assertTrue((fragment.getFilter().getParameters()[0].toString().indexOf("(osgi.ws=" + _ws + ")") != -1 ? 1 : 0) != 0);
                EquinoxExecutableActionTest.assertTrue((fragment.getFilter().getParameters()[0].toString().indexOf("(osgi.os=" + _os + ")") != -1 ? 1 : 0) != 0);
                EquinoxExecutableActionTest.assertTrue((fragment.getFilter().getParameters()[0].toString().indexOf("(osgi.arch=" + _arch + ")") != -1 ? 1 : 0) != 0);
                EquinoxExecutableActionTest.assertTrue((boolean)fragment.getProperty("org.eclipse.equinox.p2.type.fragment").equals("true"));
                return;
            }
            ++i;
        }
        EquinoxExecutableActionTest.fail();
    }

    private void verifyEclipseIU(ArrayList iuList, String idBase, String confSpec) {
        int i = 0;
        while (i < iuList.size()) {
            IInstallableUnit possibleEclipse = (IInstallableUnit)iuList.get(i);
            if (possibleEclipse.getId().equals(String.valueOf(idBase) + ".executable." + confSpec + "." + "LauncherName")) {
                EquinoxExecutableActionTest.assertTrue((boolean)possibleEclipse.getVersion().equals(this.version));
                Collection providedCapability = possibleEclipse.getProvidedCapabilities();
                this.verifyProvidedCapability(providedCapability, "org.eclipse.equinox.p2.iu", String.valueOf(idBase) + ".executable." + confSpec + "." + "LauncherName", this.version);
                EquinoxExecutableActionTest.assertTrue((providedCapability.size() == 1 ? 1 : 0) != 0);
                Collection req = possibleEclipse.getRequirements();
                EquinoxExecutableActionTest.assertTrue((req.size() == 0 ? 1 : 0) != 0);
                return;
            }
            ++i;
        }
        EquinoxExecutableActionTest.fail();
    }

    private void verifyExecIU(ArrayList iuList, String idBase, String confSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec((String)confSpec);
        String _ws = config[0];
        String _os = config[1];
        String _arch = config[2];
        int i = 0;
        while (i < iuList.size()) {
            IInstallableUnit possibleExec = (IInstallableUnit)iuList.get(i);
            if (possibleExec.getId().equals(String.valueOf(idBase) + ".executable." + confSpec)) {
                EquinoxExecutableActionTest.assertTrue((boolean)possibleExec.getFilter().equals(InstallableUnit.parseFilter((String)("(& (osgi.ws=" + _ws + ")(osgi.os=" + _os + ")(osgi.arch=" + _arch + "))"))));
                IArtifactKey eKey = (IArtifactKey)possibleExec.getArtifacts().iterator().next();
                EquinoxExecutableActionTest.assertTrue((boolean)eKey.getClassifier().equals("binary"));
                EquinoxExecutableActionTest.assertTrue((boolean)eKey.getId().equals(String.valueOf(idBase) + ".executable." + confSpec));
                EquinoxExecutableActionTest.assertTrue((boolean)eKey.getVersion().equals(this.version));
                Collection providedCapabilities = possibleExec.getProvidedCapabilities();
                this.verifyProvidedCapability(providedCapabilities, "org.eclipse.equinox.p2.iu", String.valueOf(idBase) + ".executable." + confSpec, this.version);
                this.verifyProvidedCapability(providedCapabilities, String.valueOf(this.flavorArg) + idBase, String.valueOf(idBase) + ".executable", this.version);
                EquinoxExecutableActionTest.assertTrue((providedCapabilities.size() == 2 ? 1 : 0) != 0);
                Collection requiredCapability = possibleExec.getRequirements();
                this.verifyRequiredCapability(requiredCapability, "org.eclipse.equinox.p2.iu", "org.eclipse.equinox.launcher." + (idBase.equals("mac") || idBase.equals("macCocoa") ? confSpec.substring(0, confSpec.lastIndexOf(".")) : confSpec), VersionRange.emptyRange);
                EquinoxExecutableActionTest.assertTrue((requiredCapability.size() == 1 ? 1 : 0) != 0);
                try {
                    this.checkExecutableContents(eKey);
                }
                catch (IOException iOException) {
                    EquinoxExecutableActionTest.fail();
                }
                return;
            }
            ++i;
        }
        EquinoxExecutableActionTest.fail();
    }

    private void checkExecutableContents(IArtifactKey key) throws IOException {
        File file = File.createTempFile("exec", ".zip");
        FileOutputStream fos = new FileOutputStream(file);
        try {
            IArtifactDescriptor ad = this.artifactRepository.createArtifactDescriptor(key);
            IStatus result = this.artifactRepository.getArtifact(ad, (OutputStream)fos, (IProgressMonitor)new NullProgressMonitor());
            EquinoxExecutableActionTest.assertTrue((String)"executable not published?", (boolean)result.isOK());
        }
        finally {
            fos.close();
        }
        ZipFile zip = new ZipFile(file);
        try {
            String[] stringArray = this.expectedExecutablesContents;
            int n = this.expectedExecutablesContents.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                EquinoxExecutableActionTest.assertNotNull((String)("executable zip missing " + path), (Object)zip.getEntry(path));
                ++n2;
            }
            this.checkInfoPlist(zip);
        }
        finally {
            zip.close();
        }
    }

    private void checkInfoPlist(ZipFile zip) {
        ZipEntry candidate = null;
        boolean found = false;
        Enumeration<? extends ZipEntry> iter = zip.entries();
        while (!found && iter.hasMoreElements()) {
            candidate = iter.nextElement();
            found = candidate.getName().endsWith(".app/Contents/Info.plist");
        }
        if (!found) {
            return;
        }
        try {
            String contents = this.readContentsAndClose(zip.getInputStream(candidate));
            EquinoxExecutableActionTest.assertEquals((String)this.id, (String)this.getPlistStringValue(contents, "CFBundleIdentifier"));
            EquinoxExecutableActionTest.assertEquals((String)"LauncherName", (String)this.getPlistStringValue(contents, "CFBundleExecutable"));
            EquinoxExecutableActionTest.assertEquals((String)"LauncherName", (String)this.getPlistStringValue(contents, "CFBundleName"));
            EquinoxExecutableActionTest.assertEquals((String)this.version.toString(), (String)this.getPlistStringValue(contents, "CFBundleVersion"));
        }
        catch (IOException iOException) {
            EquinoxExecutableActionTest.fail();
        }
    }

    private String getPlistStringValue(String contents, String key) {
        Pattern p = Pattern.compile("<key>" + key + "</key>\\s*<string>([^<]*)</string>");
        Matcher m = p.matcher(contents);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String readContentsAndClose(InputStream inputStream) throws IOException {
        String string;
        try {
            int rc;
            StringBuilder sb = new StringBuilder();
            InputStreamReader is = new InputStreamReader(inputStream);
            char[] buf = new char[1024];
            while ((rc = is.read(buf)) >= 0) {
                sb.append(buf, 0, rc - 1);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    protected void insertPublisherInfoBehavior() {
        this.setupArtifactRepository();
        EasyMock.expect((Object)this.publisherInfo.getArtifactRepository()).andReturn((Object)this.artifactRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getArtifactOptions()).andReturn((Object)2).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice((String)EasyMock.anyObject(), EasyMock.anyBoolean(), (String)EasyMock.anyObject(), (Version)EasyMock.anyObject(), (Class)EasyMock.anyObject())).andReturn(this.brandingAdvice);
    }

    private void setupBrandingAdvice(final String osArg, String config, File exec, final File icon) {
        this.brandingAdvice.add(new IBrandingAdvice(){

            public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
                return true;
            }

            public String getOS() {
                return osArg;
            }

            public String[] getIcons() {
                String[] stringArray;
                if (icon == null) {
                    stringArray = null;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = icon.getAbsolutePath();
                }
                return stringArray;
            }

            public String getExecutableName() {
                return "LauncherName";
            }
        });
    }
}

