/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.Collections;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.RootIUAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProductActionCapturingTest
extends ActionTest {
    File executablesFeatureLocation = null;
    String source = "";
    private Capture<RootIUAdvice> rootIUAdviceCapture;
    private Capture<ProductFileAdvice> productFileAdviceCapture;
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(ProductActionCapturingTest.getAgent());

    protected IPublisherInfo createPublisherInfoMock() {
        return (IPublisherInfo)EasyMock.createNiceMock(IPublisherInfo.class);
    }

    protected void insertPublisherInfoBehavior() {
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)((RootIUAdvice)EasyMock.isA(RootIUAdvice.class)), (Object)((RootIUAdvice)EasyMock.capture(this.rootIUAdviceCapture))));
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)((ProductFileAdvice)EasyMock.isA(ProductFileAdvice.class)), (Object)((ProductFileAdvice)EasyMock.capture(this.productFileAdviceCapture))));
        EasyMock.expect((Object)this.publisherInfo.getArtifactRepository()).andReturn((Object)this.artifactRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getArtifactOptions()).andReturn((Object)2).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice((String)EasyMock.anyObject(), EasyMock.anyBoolean(), (String)EasyMock.anyObject(), (Version)EasyMock.anyObject(), (Class)EasyMock.anyObject())).andReturn(Collections.emptyList());
        EasyMock.expectLastCall().anyTimes();
    }

    public void setUp() throws Exception {
        this.rootIUAdviceCapture = new Capture();
        this.productFileAdviceCapture = new Capture();
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    public void testSetBundleConfigData() throws Exception {
        this.addContextIU("org.eclipse.rcp.feature.group", "3.5.0.v20081110-9C9tEvNEla71LZ2jFz-RFB-t");
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "startLevel.product").toString());
        this.testAction = new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation);
        IStatus status = this.testAction.perform(this.publisherInfo, this.publisherResult, null);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        IConfigAdvice configAdvice = (IConfigAdvice)this.productFileAdviceCapture.getValue();
        BundleInfo[] bundles = configAdvice.getBundles();
        ProductActionCapturingTest.assertEquals((String)"1.0", (int)2, (int)bundles.length);
        ProductActionCapturingTest.assertEquals((String)"1.1", (String)"org.eclipse.equinox.common", (String)bundles[0].getSymbolicName());
        ProductActionCapturingTest.assertEquals((String)"1.2", (String)"1.0.0", (String)bundles[0].getVersion());
        ProductActionCapturingTest.assertEquals((String)"1.3", (int)13, (int)bundles[0].getStartLevel());
        ProductActionCapturingTest.assertEquals((String)"1.4", (boolean)false, (boolean)bundles[0].isMarkedAsStarted());
        ProductActionCapturingTest.assertEquals((String)"2.1", (String)"org.eclipse.core.runtime", (String)bundles[1].getSymbolicName());
        ProductActionCapturingTest.assertEquals((String)"2.2", (String)"2.0.0", (String)bundles[1].getVersion());
        ProductActionCapturingTest.assertEquals((String)"2.3", (int)6, (int)bundles[1].getStartLevel());
        ProductActionCapturingTest.assertEquals((String)"2.4", (boolean)true, (boolean)bundles[1].isMarkedAsStarted());
    }

    public void testPlatformProduct() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "platform.product").toString());
        this.addContextIU("org.eclipse.platform.feature.group", "1.2.3");
        this.testAction = new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation);
        IStatus status = this.testAction.perform(this.publisherInfo, this.publisherResult, null);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        IExecutableAdvice launchAdvice = (IExecutableAdvice)this.productFileAdviceCapture.getValue();
        ProductActionCapturingTest.assertEquals((String)"1.0", (String)"eclipse", (String)launchAdvice.getExecutableName());
        String[] programArgs = launchAdvice.getProgramArguments();
        ProductActionCapturingTest.assertEquals((String)"2.0", (int)0, (int)programArgs.length);
        String[] vmArgs = launchAdvice.getVMArguments();
        ProductActionCapturingTest.assertEquals((String)"3.0", (int)0, (int)vmArgs.length);
    }
}

