/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.util.Collections;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.RootIUAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IExecutableAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProductActionTestMac
extends ActionTest {
    private File executablesFeatureLocation = null;
    private Capture<RootIUAdvice> rootIUAdviceCapture;
    private Capture<ProductFileAdvice> productFileAdviceCapture;
    private String source = "";

    protected IPublisherInfo createPublisherInfoMock() {
        return (IPublisherInfo)EasyMock.createNiceMock(IPublisherInfo.class);
    }

    protected void insertPublisherInfoBehavior() {
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)((RootIUAdvice)EasyMock.isA(RootIUAdvice.class)), (Object)((RootIUAdvice)EasyMock.capture(this.rootIUAdviceCapture))));
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)((ProductFileAdvice)EasyMock.isA(ProductFileAdvice.class)), (Object)((ProductFileAdvice)EasyMock.capture(this.productFileAdviceCapture))));
        EasyMock.expect((Object)this.publisherInfo.getAdvice((String)EasyMock.anyObject(), EasyMock.anyBoolean(), (String)EasyMock.anyObject(), (Version)EasyMock.anyObject(), (Class)EasyMock.anyObject())).andReturn(Collections.emptyList());
        EasyMock.expectLastCall().anyTimes();
    }

    public void setUp() throws Exception {
        this.configSpec = AbstractPublisherAction.createConfigSpec((String)"carbon", (String)"macosx", (String)"x86");
        this.rootIUAdviceCapture = new Capture();
        this.productFileAdviceCapture = new Capture();
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    public void testPlatformProduct() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "platform.product").toString());
        this.addContextIU("org.eclipse.platform.feature.group", "3.8.3");
        this.testAction = new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation);
        IStatus status = this.testAction.perform(this.publisherInfo, this.publisherResult, null);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        IExecutableAdvice launchAdvice = (IExecutableAdvice)this.productFileAdviceCapture.getValue();
        ProductActionTestMac.assertEquals((String)"1.0", (String)"eclipse", (String)launchAdvice.getExecutableName());
        String[] programArgs = launchAdvice.getProgramArguments();
        ProductActionTestMac.assertEquals((String)"2.0", (int)2, (int)programArgs.length);
        ProductActionTestMac.assertEquals((String)"2.1", (String)"-showsplash", (String)programArgs[0]);
        ProductActionTestMac.assertEquals((String)"2.2", (String)"org.eclipse.platform", (String)programArgs[1]);
        String[] vmArgs = launchAdvice.getVMArguments();
        ProductActionTestMac.assertEquals((String)"3.0", (int)6, (int)vmArgs.length);
        ProductActionTestMac.assertEquals((String)"3.1", (String)"-Xdock:icon=../Resources/Eclipse.icns", (String)vmArgs[0]);
        ProductActionTestMac.assertEquals((String)"3.2", (String)"-XstartOnFirstThread", (String)vmArgs[1]);
        ProductActionTestMac.assertEquals((String)"3.3", (String)"-Xms40m", (String)vmArgs[2]);
        ProductActionTestMac.assertEquals((String)"3.4", (String)"-Xmx256m", (String)vmArgs[3]);
        ProductActionTestMac.assertEquals((String)"3.5", (String)"-XX:MaxPermSize=256m", (String)vmArgs[4]);
        ProductActionTestMac.assertEquals((String)"3.6", (String)"-Dorg.eclipse.swt.internal.carbon.smallFonts", (String)vmArgs[5]);
    }
}

