/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.ILicenseAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.IRootIUAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.publisher.actions.IVersionAdvice;
import org.eclipse.equinox.p2.publisher.actions.RootIUAction;
import org.eclipse.equinox.p2.publisher.actions.RootIUAdvice;
import org.eclipse.equinox.p2.publisher.actions.RootIUResultFilterAdvice;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootIUActionTest
extends ActionTest {
    private static final int CONTAINS_A = 1;
    private static final int CONTAINS_B = 2;
    private static final int EMPTY = 0;
    private static final int ALL = 3;
    private static final String ADVICE = "advice \t\t\t";
    private static final String METADATA_REPOSITORY = "metadata repo \t\t";
    private static final String PUBLISHER_RESULT = "publisher result \t";
    protected static String iu_A = "iuA";
    protected static String iu_B = "iuB";
    private IMetadataRepository metadataRepository;
    private String rootIU = "sdk";
    private Version versionArg = Version.create((String)"3.4.0.i0305");
    private Collection<IRootIUAdvice> rootIUAdviceCollection;

    public void testNullAdvice() throws Exception {
        this.debug("\n**********************************");
        this.debug(" null advice test");
        this.setupMetadataRepository(0);
        this.setupPublisherResult(0);
        this.setupPublisherInfo();
        this.testAction = new RootIUAction(this.rootIU, this.versionArg, this.rootIU);
        RootIUActionTest.assertEquals((Object)Status.OK_STATUS, (Object)this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor()));
        this.confirmResultRequired(0);
        this.cleanup();
    }

    public void testNullRepo() throws Exception {
        this.debug("\n**********************************");
        this.debug(" null repo test");
        this.setupAdvice(1);
        this.setupPublisherResult(0);
        this.setupPublisherInfo();
        this.testAction = new RootIUAction(this.rootIU, this.versionArg, this.rootIU);
        RootIUActionTest.assertEquals((Object)Status.OK_STATUS, (Object)this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor()));
        this.confirmResultRequired(0);
        this.cleanup();
    }

    public void testIUAdviceAMetdataAResultB() throws Exception {
        this.debug("\n**********************************");
        this.debug(" advice (as iu) A");
        this.setupAdvice(0);
        ArrayList<IInstallableUnit> iuCollection = new ArrayList<IInstallableUnit>();
        iuCollection.add(this.mockIU(iu_A, null));
        this.rootIUAdviceCollection.add((IRootIUAdvice)new RootIUAdvice(iuCollection));
        this.setupMetadataRepository(1);
        this.setupPublisherResult(0);
        this.setupPublisherInfo();
        this.testAction = new RootIUAction(this.rootIU, this.versionArg, this.rootIU);
        RootIUActionTest.assertEquals((Object)Status.OK_STATUS, (Object)this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor()));
        this.confirmResultRequired(1);
        this.cleanup();
    }

    public void testEmpty() throws Exception {
        this.setupAndRunRootIUTest(0, 0, 0);
    }

    public void testAdviceA() throws Exception {
        this.setupAndRunRootIUTest(1, 1, 0);
    }

    public void testAdviceAll() throws Exception {
        this.setupAndRunRootIUTest(3, 3, 0);
    }

    public void testMetadataA() throws Exception {
        this.setupAndRunRootIUTest(0, 1, 0);
    }

    public void testMetadataAll() throws Exception {
        this.setupAndRunRootIUTest(0, 3, 0);
    }

    public void testAdviceAMetadataB() throws Exception {
        this.setupAndRunRootIUTest(1, 2, 0);
    }

    public void testResultA() throws Exception {
        this.setupAndRunRootIUTest(0, 0, 1);
    }

    public void testResultAll() throws Exception {
        this.setupAndRunRootIUTest(0, 0, 3);
    }

    public void testAdviceAResultB() throws Exception {
        this.setupAndRunRootIUTest(1, 0, 2);
    }

    public void testAdviceAllResultAll() throws Exception {
        this.setupAndRunRootIUTest(3, 0, 3);
    }

    public void testAdviceAllMetadataAResultB() throws Exception {
        this.setupAndRunRootIUTest(3, 1, 2);
    }

    public void testAdviceAllMetadataAllResultAll() throws Exception {
        this.setupAndRunRootIUTest(3, 3, 3);
    }

    public void testResultFilterAdviceAllResultAll() throws Exception {
        this.setupAndrunRootFilterIUTest(3, 0, 3);
    }

    public void testResultFilterAdviceAResultAll() throws Exception {
        this.setupAndrunRootFilterIUTest(1, 0, 3);
    }

    public void testResultFilterAdviceBResultAll() throws Exception {
        this.setupAndrunRootFilterIUTest(2, 0, 3);
    }

    public void testResultFilterAdviceEmptyResultAll() throws Exception {
        this.setupAndrunRootFilterIUTest(0, 0, 3);
    }

    public void testResultFilterAdviceAllMetadataAll() throws Exception {
        this.setupAndrunRootFilterIUTest(3, 0, 3);
    }

    public void testResultFilterAdviceAMetadataAll() throws Exception {
        this.setupAndrunRootFilterIUTest(1, 0, 3);
    }

    public void testResultFilterAdviceBMetadataAll() throws Exception {
        this.setupAndrunRootFilterIUTest(2, 0, 3);
    }

    public void testResultFilterAdviceEmptyMetadataAll() throws Exception {
        this.setupAndrunRootFilterIUTest(0, 0, 3);
    }

    public void testResultFilterAdviceAllMetadataBResultA() throws Exception {
        this.setupAndrunRootFilterIUTest(3, 2, 1);
    }

    public void testResultFilterAdviceBMetadataAResultB() throws Exception {
        this.setupAndrunRootFilterIUTest(3, 1, 2);
    }

    private void setupAndRunRootIUTest(int advice, int metadataRepository, int publisherResult) {
        this.debug("\n**********************************");
        this.debug("RootIUTest");
        this.setupAdvice(advice);
        this.setupMetadataRepository(metadataRepository);
        this.setupPublisherResult(publisherResult);
        this.setupPublisherInfo();
        this.debug(this.toResultString(ADVICE, advice));
        this.debug(this.toResultString(METADATA_REPOSITORY, metadataRepository));
        this.debug(this.toResultString(PUBLISHER_RESULT, publisherResult));
        this.testAction = new RootIUAction(this.rootIU, this.versionArg, this.rootIU);
        RootIUActionTest.assertEquals((Object)Status.OK_STATUS, (Object)this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor()));
        this.confirmResultRequired(advice & metadataRepository | advice & publisherResult);
        this.cleanup();
    }

    private void setupAndrunRootFilterIUTest(int advice, int metadataRepository, int publisherResult) {
        this.debug("\n**********************************");
        this.debug("RootIUActionTest");
        this.setupFilterAdvice(advice);
        this.setupMetadataRepository(metadataRepository);
        this.setupPublisherResult(publisherResult);
        this.setupPublisherInfo();
        this.debug(this.toResultString(ADVICE, advice));
        this.debug(this.toResultString(METADATA_REPOSITORY, metadataRepository));
        this.debug(this.toResultString(PUBLISHER_RESULT, publisherResult));
        this.testAction = new RootIUAction(this.rootIU, this.versionArg, this.rootIU);
        RootIUActionTest.assertEquals((Object)Status.OK_STATUS, (Object)this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor()));
        this.confirmResultRequired(advice & publisherResult);
        this.cleanup();
    }

    private void setupFilterAdvice(int testSpec) {
        MatchQuery query = null;
        this.rootIUAdviceCollection = new ArrayList<IRootIUAdvice>();
        if ((testSpec & 1) > 0) {
            query = new MatchQuery(){

                public boolean isMatch(Object candidate) {
                    return candidate instanceof IInstallableUnit && ((IInstallableUnit)candidate).getId().equals(iu_A);
                }
            };
            this.rootIUAdviceCollection.add((IRootIUAdvice)new RootIUResultFilterAdvice((IQuery)query));
        }
        if ((testSpec & 2) > 0) {
            query = new MatchQuery(){

                public boolean isMatch(Object candidate) {
                    return candidate instanceof IInstallableUnit && ((IInstallableUnit)candidate).getId().equals(iu_B);
                }
            };
            this.rootIUAdviceCollection.add((IRootIUAdvice)new RootIUResultFilterAdvice((IQuery)query));
        }
        if (0 > 0) {
            query = new MatchQuery(){

                public boolean isMatch(Object candidate) {
                    return false;
                }
            };
            this.rootIUAdviceCollection.add((IRootIUAdvice)new RootIUResultFilterAdvice((IQuery)query));
        }
    }

    private void confirmResultRequired(int testSpec) {
        ArrayList ius = new ArrayList(this.publisherResult.getIUs(this.rootIU, "non_root"));
        RootIUActionTest.assertTrue((ius.size() == 1 ? 1 : 0) != 0);
        IInstallableUnit iu = (IInstallableUnit)ius.get(0);
        RootIUActionTest.assertTrue((iu != null ? 1 : 0) != 0);
        RootIUActionTest.assertTrue((boolean)iu.getVersion().equals(this.versionArg));
        Collection required = iu.getRequirements();
        if (0 > 0) {
            RootIUActionTest.assertEquals((int)required.size(), (int)0);
        }
        String confirmedIUs = "";
        int numConfirmed = 0;
        if ((testSpec & 1) > 0) {
            RootIUActionTest.assertTrue((boolean)this.contains(required, iu_A));
            confirmedIUs = String.valueOf(confirmedIUs) + iu_A + ' ';
            ++numConfirmed;
        }
        if ((testSpec & 2) > 0) {
            RootIUActionTest.assertTrue((boolean)this.contains(required, iu_B));
            confirmedIUs = String.valueOf(confirmedIUs) + iu_B;
            ++numConfirmed;
        }
        if (numConfirmed != required.size()) {
            this.debug("Not all required ius present / accounted for.");
            RootIUActionTest.fail();
        }
        if (confirmedIUs.length() > 0) {
            this.debug("Confirmed \t\t " + confirmedIUs);
        } else {
            this.debug("Confirmed \t\t  Empty");
        }
    }

    private boolean contains(Collection<IRequirement> required, String iu) {
        for (IRequiredCapability iRequiredCapability : required) {
            if (!iRequiredCapability.getName().equalsIgnoreCase(iu)) continue;
            return true;
        }
        return false;
    }

    public void setupPublisherResult(int testSpec) {
        super.setupPublisherResult();
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        if ((testSpec & 1) > 0) {
            ius.add(this.mockIU(iu_A, null));
        }
        if ((testSpec & 2) > 0) {
            ius.add(this.mockIU(iu_B, null));
        }
        this.publisherResult.addIUs(ius, "root");
    }

    private void setupMetadataRepository(int testSpec) {
        ArrayList<IInstallableUnit> repoContents = new ArrayList<IInstallableUnit>();
        if ((testSpec & 1) > 0) {
            repoContents.add(this.mockIU(iu_A, null));
        }
        if ((testSpec & 2) > 0) {
            repoContents.add(this.mockIU(iu_B, null));
        }
        IInstallableUnit[] ius = repoContents.toArray(new IInstallableUnit[repoContents.size()]);
        this.metadataRepository = new TestMetadataRepository(RootIUActionTest.getAgent(), ius);
    }

    public void setupAdvice(int testSpec) {
        ArrayList<String> publishIUs = new ArrayList<String>();
        if ((testSpec & 1) > 0) {
            publishIUs.add(iu_A);
        }
        if ((testSpec & 2) > 0) {
            publishIUs.add(iu_B);
        }
        this.rootIUAdviceCollection = new ArrayList<IRootIUAdvice>();
        this.rootIUAdviceCollection.add((IRootIUAdvice)new RootIUAdvice(publishIUs));
    }

    @Override
    public void insertPublisherInfoBehavior() {
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, this.rootIU, this.versionArg, ICapabilityAdvice.class)).andReturn(new ArrayList()).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, true, null, null, IRootIUAdvice.class)).andReturn(this.rootIUAdviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, true, null, null, IVersionAdvice.class)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, this.rootIU, this.versionArg, ITouchpointAdvice.class)).andReturn(new ArrayList()).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, this.rootIU, this.versionArg, IUpdateDescriptorAdvice.class)).andReturn(new ArrayList()).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, this.rootIU, this.versionArg, IPropertyAdvice.class)).andReturn(new ArrayList()).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, this.rootIU, this.versionArg, IAdditionalInstallableUnitAdvice.class)).andReturn(new ArrayList()).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, true, this.rootIU, this.versionArg, ILicenseAdvice.class)).andReturn(new ArrayList()).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getMetadataRepository()).andReturn((Object)this.metadataRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getContextMetadataRepository()).andReturn(null).anyTimes();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.rootIUAdviceCollection = null;
        if (this.metadataRepository != null) {
            this.metadataRepository.removeAll();
            this.metadataRepository = null;
        }
    }

    private String toResultString(String setup, int arg) {
        return String.valueOf(setup) + this.toArgString(arg);
    }

    private String toArgString(int testSpec) {
        if (testSpec == 0) {
            return " Empty";
        }
        String result = " ";
        if ((testSpec & 1) > 0) {
            result = String.valueOf(result) + iu_A;
        }
        if ((testSpec & 2) > 0) {
            result = String.valueOf(result) + " " + iu_B;
        }
        return result;
    }
}

