/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.File;
import java.net.MalformedURLException;
import junit.framework.Test;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.p2.tests.reconciler.dropins.AbstractSharedBundleProductTest;
import org.eclipse.equinox.p2.tests.reconciler.dropins.SharedBundleProductTestSuite;

public class BasicProductTests
extends AbstractSharedBundleProductTest {
    public BasicProductTests(String name) {
        super(name);
    }

    public static Test suite() {
        SharedBundleProductTestSuite suite = new SharedBundleProductTestSuite();
        suite.setName(BasicProductTests.class.getName());
        suite.addTest((Test)new BasicProductTests("testAddRemove"));
        suite.addTest((Test)new BasicProductTests("testReplace"));
        return suite;
    }

    public void testAddRemove() {
        this.assertInitialized();
        File jar = BasicProductTests.getTestData("1.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        File shared = new File(output, "shared/plugins");
        File target = new File(shared, jar.getName());
        BasicProductTests.copy("1.1", jar, target);
        String targetURLString = null;
        try {
            targetURLString = target.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            BasicProductTests.fail("1.99", e);
        }
        Configuration config = this.loadConfiguration();
        this.addBundleToConfiguration(config, targetURLString);
        this.saveConfiguration(config);
        this.reconcile("4.0");
        this.assertExistsInBundlesInfo("5.0", "myBundle");
        BasicProductTests.assertTrue((String)"6.0", (boolean)BasicProductTests.delete(target));
        this.removeBundleFromConfiguration(config, targetURLString);
        this.reconcile("6.5");
        this.assertDoesNotExistInBundlesInfo("7.0", "myBundle");
    }

    public void testReplace() {
        this.assertInitialized();
        File jar = BasicProductTests.getTestData("1.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        File shared = new File(output, "shared/plugins");
        File target = new File(shared, jar.getName());
        BasicProductTests.copy("1.1", jar, target);
        String targetURLString = null;
        try {
            targetURLString = target.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            BasicProductTests.fail("1.99", e);
        }
        Configuration config = this.loadConfiguration();
        this.addBundleToConfiguration(config, targetURLString);
        this.saveConfiguration(config);
        this.reconcile("2.0");
        this.assertExistsInBundlesInfo("2.1", "myBundle", "1.0.0");
        File higherJAR = BasicProductTests.getTestData("3.0", "testData/reconciler/plugins/myBundle_2.0.0.jar");
        File higherTarget = new File(shared, higherJAR.getName());
        BasicProductTests.copy("3.1", higherJAR, higherTarget);
        String higherTargetURLString = null;
        try {
            higherTargetURLString = higherTarget.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            BasicProductTests.fail("3.99", e);
        }
        this.removeBundleFromConfiguration(config, targetURLString);
        this.addBundleToConfiguration(config, higherTargetURLString);
        this.saveConfiguration(config);
        this.reconcile("3.5");
        this.assertExistsInBundlesInfo("3.6", "myBundle", "2.0.0");
        this.assertDoesNotExistInBundlesInfo("3.7.0", "myBundle", "1.0.0");
        BasicProductTests.assertTrue((String)"6.0", (boolean)BasicProductTests.delete(target));
        BasicProductTests.assertTrue((String)"6.1", (boolean)BasicProductTests.delete(higherTarget));
        this.removeBundleFromConfiguration(config, higherTargetURLString);
        this.reconcile("6.5");
        this.assertDoesNotExistInBundlesInfo("7.0", "myBundle");
    }
}

