/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.File;
import junit.framework.Test;
import org.eclipse.equinox.p2.tests.reconciler.dropins.AbstractReconcilerTest;
import org.eclipse.equinox.p2.tests.reconciler.dropins.ReconcilerTestSuite;

public class FeaturePatchTest
extends AbstractReconcilerTest {
    public FeaturePatchTest(String name) {
        super(name);
    }

    public static Test suite() {
        ReconcilerTestSuite suite = new ReconcilerTestSuite();
        suite.setName(FeaturePatchTest.class.getName());
        suite.addTest((Test)new FeaturePatchTest("testPatchingDroppedInFeature"));
        suite.addTest((Test)new FeaturePatchTest("testAddBundle"));
        return suite;
    }

    public void testPatchingDroppedInFeature() {
        if (this.DISABLED) {
            return;
        }
        this.assertInitialized();
        File file = FeaturePatchTest.getTestData("1.0", "testData/reconciler/features/myFeature_1.0.0");
        this.add("1.1", "dropins/features", file);
        file = FeaturePatchTest.getTestData("1.2", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("1.3", "dropins/plugins", file);
        this.reconcile("1.4");
        this.assertExistsInBundlesInfo("1.5", "myBundle", "1.0.0");
        file = FeaturePatchTest.getTestData("2.0", "testData/reconciler/features/myFeaturePatch_2.0.0");
        this.add("2.1", "dropins/features", file);
        file = FeaturePatchTest.getTestData("2.2", "testData/reconciler/plugins/myBundle_2.0.0.jar");
        this.add("2.3", "dropins/plugins", file);
        this.reconcile("2.4");
        this.assertExistsInBundlesInfo("2.5", "myBundle", "1.0.0");
        this.assertExistsInBundlesInfo("2.6", "myBundle", "2.0.0");
        this.remove("3.0", "dropins/features", "myFeature_1.0.0");
        this.remove("3.1", "dropins/plugins", "myBundle_1.0.0.jar");
        this.remove("3.2", "dropins/features", "myFeaturePatch_2.0.0");
        this.remove("3.3", "dropins/plugins", "myBundle_2.0.0.jar");
        this.assertDoesNotExistInBundlesInfo("3.4", "myBundle");
    }

    public void testAddBundle() {
        if (this.DISABLED) {
            return;
        }
        this.assertInitialized();
        File file = FeaturePatchTest.getTestData("1.0", "testData/reconciler/features/myFeature_1.0.0");
        this.add("1.1", "dropins/features", file);
        file = FeaturePatchTest.getTestData("1.2", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("1.3", "dropins/plugins", file);
        this.reconcile("1.4");
        this.assertExistsInBundlesInfo("1.5", "myBundle", "1.0.0");
        file = FeaturePatchTest.getTestData("2.0", "testData/reconciler/features/myFeaturePatch_1.0.0");
        this.add("2.1", "dropins/features", file);
        file = FeaturePatchTest.getTestData("2.2", "testData/reconciler/plugins/mySingletonBundle_1.0.0.jar");
        this.add("2.3", "dropins/plugins", file);
        this.reconcile("2.4");
        this.assertExistsInBundlesInfo("2.5", "myBundle", "1.0.0");
        this.assertExistsInBundlesInfo("2.6", "mySingletonBundle", "1.0.0");
        this.remove("3.0", "dropins/features", "myFeature_1.0.0");
        this.remove("3.1", "dropins/plugins", "myBundle_1.0.0.jar");
        this.remove("3.2", "dropins/features", "myFeaturePatch_1.0.0");
        this.remove("3.3", "dropins/plugins", "mySingletonBundle_1.0.0.jar");
        this.assertDoesNotExistInBundlesInfo("3.4", "myBundle");
        this.assertDoesNotExistInBundlesInfo("3.5", "mySingletonBundle");
    }
}

