/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.ProfileSynchronizer;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;

public class ProfileSynchronizerTest
extends AbstractProvisioningTest {
    private IProfile sdkProfile;
    private IProvisioningAgent agent;
    private IProfileRegistry registry;

    protected void setUp() throws Exception {
        super.setUp();
        this.initializeReconciler();
        File tmpFolder = this.getTempFolder();
        ProfileSynchronizerTest.copy("copying initialProfile", ProfileSynchronizerTest.getTestData("p2 folder for synchronizer test", "testData/profileSynchronizerTest/"), tmpFolder);
        this.agent = ProfileSynchronizerTest.getAgentProvider().createAgent(new File(tmpFolder, "p2").toURI());
        this.registry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
        this.sdkProfile = this.registry.getProfile("SDKProfile");
        IProvisioningPlan plan = engine.createPlan(this.sdkProfile, null);
        File installFolder = this.getTempFolder();
        plan.setProfileProperty("org.eclipse.equinox.p2.installFolder", installFolder.getAbsolutePath());
        plan.setProfileProperty("org.eclipse.equinox.p2.cache", installFolder.getAbsolutePath());
        engine.perform(plan, null);
    }

    public void testPropertyAreProperlyPutBack() throws IllegalArgumentException {
        Set oldRoots = this.sdkProfile.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString()), null).toUnmodifiableSet();
        ProfileSynchronizerTest.assertFalse((boolean)this.sdkProfile.query(QueryUtil.createIUQuery((String)"aniefer.junit.headless"), null).isEmpty());
        int originalSize = this.sdkProfile.query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet().size();
        ProfileSynchronizer sync = new ProfileSynchronizer(this.agent, this.sdkProfile, new ArrayList());
        sync.synchronize(null);
        Set newRoots = this.registry.getProfile("SDKProfile").query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString()), null).toSet();
        newRoots.removeAll(oldRoots);
        ProfileSynchronizerTest.assertEquals((int)0, (int)newRoots.size());
        ProfileSynchronizerTest.assertTrue((boolean)this.registry.getProfile("SDKProfile").query(QueryUtil.createIUQuery((String)"aniefer.junit.headless"), null).isEmpty());
        ProfileSynchronizerTest.assertEquals((int)(originalSize - 1), (int)this.registry.getProfile("SDKProfile").query(QueryUtil.ALL_UNITS, null).toUnmodifiableSet().size());
    }

    private void initializeReconciler() throws IllegalAccessException {
        Field[] fields = Activator.class.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals("bundleContext")) {
                fields[i].setAccessible(true);
                fields[i].set(Activator.class, TestActivator.getContext());
                break;
            }
            ++i;
        }
    }
}

