/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import java.util.EventObject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.repository.DownloadProgressEvent;
import org.eclipse.equinox.internal.p2.transport.ecf.FileReader;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.junit.Test;

public class FileReaderTest2
extends AbstractProvisioningTest {
    @Test
    public void testPauseAndResume() throws IOException, CoreException {
        IProvisioningEventBus eventBus = this.getEventBus();
        class PauseResumeProvisioningListener
        implements ProvisioningListener {
            boolean downloadIsOngoing = false;
            boolean isPaused = false;
            float downloadProgressEventAfterPaused = 0.0f;

            PauseResumeProvisioningListener() {
            }

            public void notify(EventObject event) {
                if (event instanceof DownloadProgressEvent) {
                    this.downloadIsOngoing = true;
                    if (this.isPaused) {
                        this.downloadProgressEventAfterPaused += 1.0f;
                    }
                }
            }
        }
        final PauseResumeProvisioningListener listener = new PauseResumeProvisioningListener();
        eventBus.addListener((ProvisioningListener)listener);
        try {
            final FileReader reader = new FileReader(FileReaderTest2.getAgent(), null);
            final Job resumeJob = new Job("resume"){
                {
                    super($anonymous0);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    listener.isPaused = false;
                    System.out.println("Download job is resumed at " + new Date());
                    reader.resume();
                    return Status.OK_STATUS;
                }
            };
            PauseJob pauseJob = new PauseJob(this, "pause", reader){
                {
                    super($anonymous0, $anonymous1);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    reader.pause();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    listener.isPaused = true;
                    System.out.println("Download job is paused at " + new Date());
                    resumeJob.schedule(10000L);
                    return Status.OK_STATUS;
                }
            };
            this.doFileReaderTest(pauseJob, null);
            FileReaderTest2.assertTrue((String)"No download progress event is fired!", (boolean)listener.downloadIsOngoing);
            FileReaderTest2.assertEquals((String)"Download is not paused!", (float)0.0f, (float)listener.downloadProgressEventAfterPaused, (float)1.0f);
        }
        finally {
            eventBus.removeListener((ProvisioningListener)listener);
        }
    }

    @Test
    public void testPauseAndResumeMoreThanOnce() throws IOException, CoreException {
        final FileReader reader = new FileReader(FileReaderTest2.getAgent(), null);
        PauseJob pauseJob = new PauseJob(this, "pause", reader){
            int count;
            final int threhold = 3;
            {
                super($anonymous0, $anonymous1);
                this.count = 0;
                this.threhold = 3;
            }

            protected IStatus run(IProgressMonitor monitor) {
                reader.pause();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Download job is paused at " + new Date());
                abstract class ResumeJob
                extends Job {
                    PauseJob pausejob;

                    public ResumeJob(String name, PauseJob pauseJob) {
                        super(name);
                        this.pausejob = pauseJob;
                    }
                }
                ResumeJob resumeJob = new ResumeJob(this, "resume", this){
                    {
                        super($anonymous0, $anonymous1);
                    }

                    protected IStatus run(IProgressMonitor monitor1) {
                        System.out.println("Download job is resumed at " + new Date());
                        reader.resume();
                        if (count++ < 3) {
                            this.pausejob.schedule(5000L);
                        }
                        return Status.OK_STATUS;
                    }
                };
                resumeJob.schedule(10000L);
                return Status.OK_STATUS;
            }
        };
        this.doFileReaderTest(pauseJob, null);
    }

    @Test
    public void testCancelPausedDownload() throws IOException, CoreException {
        final FileReader reader = new FileReader(FileReaderTest2.getAgent(), null);
        PauseJob pauseJob = new PauseJob(this, "pause", reader){

            protected IStatus run(IProgressMonitor monitor) {
                reader.pause();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Download job is paused at " + new Date());
                return Status.OK_STATUS;
            }
        };
        try {
            class CancelDownloadListener
            extends JobChangeAdapter {
                boolean cancelDownload = false;

                CancelDownloadListener() {
                }

                public void done(IJobChangeEvent event) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.cancelDownload = true;
                }
            }
            final CancelDownloadListener pauseJobListener = new CancelDownloadListener();
            pauseJob.addJobChangeListener((IJobChangeListener)pauseJobListener);
            this.doFileReaderTest(pauseJob, (IProgressMonitor)new NullProgressMonitor(){
                {
                }

                public boolean isCanceled() {
                    return pauseJobListener.cancelDownload;
                }
            });
            FileReaderTest2.fail((String)"Don't throw operation cancel exception.");
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void doFileReaderTest(final PauseJob pauseJob, IProgressMonitor monitor) throws IOException, CoreException {
        OutputStream out = null;
        FileOutputStream out1 = null;
        File tmpFolder = this.getTempFolder();
        File tmpFile = new File(tmpFolder, "testDownloadPauseResume.zip");
        File tmpFile1 = new File(tmpFolder, "testDownloadWithoutPause.zip");
        ProvisioningListener listener = new ProvisioningListener(){
            boolean startedPauseJob = false;

            public void notify(EventObject o) {
                if (!this.startedPauseJob && o instanceof DownloadProgressEvent) {
                    pauseJob.schedule();
                    this.startedPauseJob = true;
                }
            }
        };
        this.getEventBus().addListener(listener);
        try {
            tmpFile1.createNewFile();
            out1 = new FileOutputStream(tmpFile1);
            FileReader readerWithoutPausing = new FileReader(null, null);
            readerWithoutPausing.readInto(URI.create("http://download.eclipse.org/releases/juno/201206270900/content.jar"), (OutputStream)out1, null);
            FileReaderTest2.assertNotNull((Object)readerWithoutPausing.getResult());
            FileReaderTest2.assertTrue((boolean)readerWithoutPausing.getResult().isOK());
            tmpFile.createNewFile();
            out = new FileOutputStream(tmpFile);
            FileReader reader = pauseJob.getReader();
            reader.readInto(URI.create("http://download.eclipse.org/releases/juno/201206270900/content.jar"), out, monitor);
            FileReaderTest2.assertNotNull((Object)reader.getResult());
            FileReaderTest2.assertTrue((boolean)reader.getResult().isOK());
            FileReaderTest2.assertEquals((String)"File with pausing/resuming is not identical with file without pausing.", (long)tmpFile1.length(), (long)tmpFile.length());
        }
        finally {
            this.getEventBus().removeListener(listener);
            if (out1 != null) {
                ((OutputStream)out1).close();
            }
            tmpFile1.delete();
            if (out != null) {
                out.close();
            }
            tmpFile.delete();
            FileReaderTest2.delete(tmpFolder);
        }
    }

    abstract class PauseJob
    extends Job {
        private FileReader reader;

        public PauseJob(String name, FileReader reader) {
            super(name);
            this.reader = reader;
        }

        public FileReader getReader() {
            return this.reader;
        }
    }
}

