/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sat4j.smoke;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.reader.OPBEclipseReader2007;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.TimeoutException;

public class SmokeTestSAT4J
extends AbstractProvisioningTest {
    private IProblem invokeSolver(File problemFile) throws FileNotFoundException, ParseFormatException, ContradictionException, TimeoutException {
        IPBSolver solver = SolverFactory.newEclipseP2();
        solver.setTimeoutOnConflicts(1000);
        OPBEclipseReader2007 reader = new OPBEclipseReader2007(solver);
        FileReader fr = null;
        fr = new FileReader(problemFile);
        IProblem problem = reader.parseInstance((Reader)fr);
        if (problem.isSatisfiable()) {
            return problem;
        }
        return null;
    }

    public void testBogusFile() {
        File data = SmokeTestSAT4J.getTestData("Opb file 247638", "testData/sat4j/Bug247638.opb");
        ParseFormatException raised = null;
        try {
            this.invokeSolver(data);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ParseFormatException e) {
            raised = e;
        }
        catch (ContradictionException e) {
            SmokeTestSAT4J.fail("Contradiction exception", e);
        }
        catch (TimeoutException e) {
            SmokeTestSAT4J.fail("Timeout exception", e);
        }
        SmokeTestSAT4J.assertNotNull((Object)((Object)raised));
    }

    public void testBug247567() {
        File data = SmokeTestSAT4J.getTestData("Opb file 247567", "testData/sat4j/Bug247567.opb");
        Throwable raised = null;
        try {
            IProblem pb = this.invokeSolver(data);
            SmokeTestSAT4J.assertNotNull((Object)pb);
            int i = 1;
            while (i <= 6) {
                pb.model(i);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            raised = e;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (ParseFormatException e) {
            raised = e;
        }
        catch (ContradictionException e) {
            SmokeTestSAT4J.fail("Contradiction exception", e);
        }
        catch (TimeoutException e) {
            SmokeTestSAT4J.fail("Timeout exception", e);
        }
        SmokeTestSAT4J.assertNull((Object)raised);
    }
}

