/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sharedinstall;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.migration.MigrationSupport;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.IUDescription;
import org.eclipse.equinox.p2.tests.IULoader;

public class NeedsMigration
extends AbstractProvisioningTest {
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit sdk1;
    @IUDescription(content="package: sdk \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit sdk2;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit egit1;
    @IUDescription(content="package: egit \nsingleton: true\nversion: 2 \n")
    public IInstallableUnit egit2;
    @IUDescription(content="package: cdt \nsingleton: true\nversion: 1 \n")
    public IInstallableUnit cdt1;
    @IUDescription(content="package: eppPackage \nsingleton: true\nversion: 1 \ndepends: sdk = 1, egit =1")
    public IInstallableUnit eppPackage;
    private IPlanner planner;
    private IEngine engine;
    private MigrationSupport scheduler;
    private Method needsMigrationMethod;

    protected void setUp() throws Exception {
        IULoader.loadIUs((Object)this);
        this.planner = NeedsMigration.createPlanner();
        this.engine = NeedsMigration.createEngine();
        this.scheduler = new MigrationSupport();
        this.createTestMetdataRepository(new IInstallableUnit[]{this.sdk1, this.sdk2, this.egit1, this.egit2, this.cdt1, this.eppPackage});
        this.needsMigrationMethod = this.scheduler.getClass().getDeclaredMethod("findUnitstoMigrate", IProfile.class, IProfile.class);
        this.needsMigrationMethod.setAccessible(true);
    }

    public void testEmptyUserProfile() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.install(currentBaseProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertFalse((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testSameVersions() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.install(previousUserProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.install(currentBaseProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertFalse((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testDifferentVersions() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk2}, true, this.planner, this.engine));
        NeedsMigration.assertFalse((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testUserProfileNewerThanBaseVersion() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.sdk2, this.egit2}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk2, this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertTrue((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testBaseEncompassWhatUserHas() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.sdk1, this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.eppPackage}, true, this.planner, this.engine));
        NeedsMigration.assertFalse((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testBaseEncompassSomePartsOfWhatUserHas() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.sdk1, this.egit1, this.cdt1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.eppPackage}, true, this.planner, this.engine));
        NeedsMigration.assertTrue((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testBaseEncompassSomePartsOfWhatUserHas2() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.sdk1, this.egit1, this.cdt1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk1, this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertTrue((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testNoIUsInstalledInUserProfile() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRootsAndFlaggedAsBase(previousUserProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk2}, true, this.planner, this.engine));
        NeedsMigration.assertFalse((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testOneIUInUserSpaceNotAvailableInBase() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRootsAndFlaggedAsBase(previousUserProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk2}, true, this.planner, this.engine));
        NeedsMigration.assertTrue((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testLowerVersionAvailableInBase() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRootsAndFlaggedAsBase(previousUserProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.egit2}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk2, this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertTrue((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testHigerVersionAvailableInBase() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRootsAndFlaggedAsBase(previousUserProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk2, this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertFalse((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    public void testSameVersionAvailableInBase() {
        IProfile previousUserProfile = this.createProfile("previous" + this.getName());
        IProfile currentBaseProfile = this.createProfile("current" + this.getName());
        NeedsMigration.assertOK(this.installAsRootsAndFlaggedAsBase(previousUserProfile, new IInstallableUnit[]{this.sdk1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(previousUserProfile, new IInstallableUnit[]{this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertOK(this.installAsRoots(currentBaseProfile, new IInstallableUnit[]{this.sdk2, this.egit1}, true, this.planner, this.engine));
        NeedsMigration.assertFalse((boolean)this.needsMigration(previousUserProfile, currentBaseProfile));
    }

    private boolean needsMigration(IProfile previousUserProfile, IProfile currentBaseProfile) {
        try {
            return !((Collection)this.needsMigrationMethod.invoke((Object)this.scheduler, previousUserProfile, currentBaseProfile)).isEmpty();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

