/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.simpleconfigurator.manipulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorImpl;
import org.eclipse.equinox.internal.simpleconfigurator.utils.URIUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SimpleConfiguratorManipulatorTests
extends AbstractProvisioningTest {
    public void testSaveConfiguration() throws Exception {
        File folder = this.getTestFolder("saveConfiguration");
        File infoFile = new File(folder, "bundle.info");
        URI baseFile = this.getTempFolder().toURI();
        BundleInfo[] bundles = new BundleInfo[]{new BundleInfo("a", "1.0.0", new File(folder, "plugins/a_1.0.0.jar").toURI(), -1, false)};
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        manipulator.saveConfiguration(bundles, infoFile, folder.toURI());
        bundles = manipulator.loadConfiguration((InputStream)new FileInputStream(infoFile), baseFile);
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)URIUtil.append((URI)baseFile, (String)"plugins/a_1.0.0.jar"));
        bundles = new BundleInfo[]{new BundleInfo("b", "1.0.0", new URI("plugins/b_1.0.0.jar"), -1, false)};
        manipulator.saveConfiguration(bundles, infoFile, null);
        bundles = manipulator.loadConfiguration((InputStream)new FileInputStream(infoFile), baseFile);
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)URIUtil.append((URI)baseFile, (String)"plugins/b_1.0.0.jar"));
        URI absolute = new File(folder, "plugins/c_1.0.0.jar").toURI();
        bundles = new BundleInfo[]{new BundleInfo("c", "1.0.0", absolute, -1, false)};
        manipulator.saveConfiguration(bundles, infoFile, null);
        bundles = manipulator.loadConfiguration((InputStream)new FileInputStream(infoFile), baseFile);
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)absolute);
    }

    public void testLocationEncoding() throws Exception {
        File folder = this.getTestFolder("locationEncoding");
        File configurationFile = new File(folder, "bundle.info");
        BundleInfo[] bundles = new BundleInfo[]{new BundleInfo("a", "1.0.0", new File(folder, "plu%2Cins/a_1.0.0.jar").toURI(), -1, false), new BundleInfo("b", "1.0.0", new File(folder, "plu,ins/b_1.0.0.jar").toURI(), -1, false)};
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        manipulator.saveConfiguration(bundles, configurationFile, folder.toURI());
        bundles = manipulator.loadConfiguration((InputStream)new FileInputStream(configurationFile), folder.toURI());
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)new File(folder, "plu%2Cins/a_1.0.0.jar").toURI());
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[1].getLocation(), (Object)new File(folder, "plu,ins/b_1.0.0.jar").toURI());
    }

    public void testUTF8Encoding() throws Exception {
        File folder = this.getTestFolder("utf8Test");
        File configurationFile = new File(folder, "bundle.info");
        BundleInfo[] bundles = new BundleInfo[]{new BundleInfo("a", "1.0.0", new File(folder, "\u0ca0_\u0ca0.jar").toURI(), -1, false)};
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        manipulator.saveConfiguration(bundles, configurationFile, folder.toURI());
        bundles = manipulator.loadConfiguration((InputStream)new FileInputStream(configurationFile), folder.toURI());
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)new File(folder, "\u0ca0_\u0ca0.jar").toURI());
    }
}

