/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.testserver.helper;

import java.security.cert.Certificate;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.testserver.helper.TestServerController;
import org.osgi.framework.BundleContext;

public class AbstractTestServerClientCase
extends TestCase {
    private int counter = 0;

    public AbstractTestServerClientCase() {
    }

    public AbstractTestServerClientCase(String name) {
        super(name);
    }

    public void run(TestResult result) {
        ProtectedRunner p = new ProtectedRunner(result);
        result.runProtected((Test)this, (Protectable)p);
    }

    protected String getBaseURL() {
        return "http://localhost:" + System.getProperty("org.osgi.service.http.port", "8080");
    }

    protected static IProvisioningAgent getAgent() {
        return (IProvisioningAgent)ServiceHelper.getService((BundleContext)TestActivator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
    }

    protected void basicRun(TestResult result) {
        super.run(result);
    }

    public static void oneTimeSetUp() throws Exception {
        TestServerController.checkSetUp();
    }

    public static void oneTimeTearDown() throws Exception {
        TestServerController.checkTearDown();
    }

    public void tearDown() throws Exception {
        TestServerController.checkTearDown();
    }

    public void setUp() throws Exception {
        TestServerController.checkSetUp();
    }

    public int getLoginCount() {
        return this.counter;
    }

    public void setAladdinLoginService() {
        this.counter = 0;
        TestServerController.setServiceUI(new AladdinNotSavedService());
    }

    public void setBadLoginService() {
        this.counter = 0;
        TestServerController.setServiceUI(new AladdinNotSavedService());
    }

    public void clearLoginService() {
        this.counter = 0;
        TestServerController.setServiceUI(null);
    }

    public class AladdinNotSavedService
    extends UIServices {
        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            return new UIServices.AuthenticationInfo("Aladdin", "open sesame", false);
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            AbstractTestServerClientCase.assertEquals((String)"Aladdin", (String)previousInfo.getUserName());
            AbstractTestServerClientCase.assertEquals((String)"open sesame", (String)previousInfo.getPassword());
            AbstractTestServerClientCase.assertEquals((boolean)false, (boolean)previousInfo.saveResult());
            return previousInfo;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            return new UIServices.TrustInfo(null, false, true);
        }
    }

    public class BadLoginService
    extends UIServices {
        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            return new UIServices.AuthenticationInfo("moria", "friend", false);
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            AbstractTestServerClientCase.assertEquals((String)"moria", (String)previousInfo.getUserName());
            AbstractTestServerClientCase.assertEquals((String)"friend", (String)previousInfo.getPassword());
            AbstractTestServerClientCase.assertEquals((boolean)false, (boolean)previousInfo.saveResult());
            return previousInfo;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            return new UIServices.TrustInfo(null, false, true);
        }
    }

    private class ProtectedRunner
    implements Protectable {
        private TestResult result;

        ProtectedRunner(TestResult result) {
            this.result = result;
        }

        public void protect() throws Exception {
            AbstractTestServerClientCase.oneTimeSetUp();
            AbstractTestServerClientCase.this.basicRun(this.result);
            AbstractTestServerClientCase.oneTimeTearDown();
        }
    }
}

