/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.testserver.helper;

import java.io.IOException;
import java.net.ServerSocket;
import java.security.cert.Certificate;
import java.util.Hashtable;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;

public class TestServerController {
    private static final String BUNDLE_TESTSERVER = "org.eclipse.equinox.p2.testserver";
    private static final String BUNDLE_EQUINOX_HTTP = "org.eclipse.equinox.http";
    public static final String PROP_TESTSERVER_PORT = "org.osgi.service.http.port";
    static UIServices hookedAuthDialog;
    private static ServiceRegistration certificateUIRegistration;
    private static int setUpCounter;
    private static ServiceReference packageAdminRef;

    static {
        setUpCounter = 0;
    }

    private static Bundle getBundle(PackageAdmin packageAdmin, String symbolicName) {
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++i;
        }
        return null;
    }

    private static boolean startTransient(PackageAdmin packageAdmin, String bundleName) throws BundleException {
        Bundle bundle = TestServerController.getBundle(packageAdmin, bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    private static void stopTransient(PackageAdmin packageAdmin, String bundleName) throws BundleException {
        Bundle bundle = TestServerController.getBundle(packageAdmin, bundleName);
        if (bundle != null) {
            bundle.stop(1);
        }
    }

    private static int obtainFreePort() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    public static void oneTimeSetUp() throws Exception {
        BundleContext context = TestActivator.getContext();
        packageAdminRef = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin pkgAdmin = (PackageAdmin)context.getService(packageAdminRef);
        TestServerController.stopTransient(pkgAdmin, BUNDLE_EQUINOX_HTTP);
        TestServerController.stopTransient(pkgAdmin, BUNDLE_TESTSERVER);
        System.setProperty(PROP_TESTSERVER_PORT, Integer.toString(TestServerController.obtainFreePort()));
        if (!TestServerController.startTransient(pkgAdmin, BUNDLE_EQUINOX_HTTP)) {
            throw new IllegalStateException("Unable to start bundle org.eclipse.equinox.http");
        }
        if (!TestServerController.startTransient(pkgAdmin, BUNDLE_TESTSERVER)) {
            throw new IllegalStateException("Unable to start bundle org.eclipse.equinox.p2.testserver");
        }
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(1);
        properties.put("service.ranking", new Integer(Integer.MAX_VALUE));
        certificateUIRegistration = context.registerService(UIServices.class.getName(), (Object)new DelegatingAuthService(), properties);
        setUpCounter = 1;
    }

    public static void oneTimeTearDown() throws Exception {
        BundleContext context = TestActivator.getContext();
        certificateUIRegistration.unregister();
        PackageAdmin pkgAdmin = (PackageAdmin)context.getService(packageAdminRef);
        TestServerController.stopTransient(pkgAdmin, BUNDLE_TESTSERVER);
        TestServerController.stopTransient(pkgAdmin, BUNDLE_EQUINOX_HTTP);
        context.ungetService(packageAdminRef);
        setUpCounter = 0;
    }

    public static synchronized void checkSetUp() throws Exception {
        if (setUpCounter == 0) {
            TestServerController.oneTimeSetUp();
            return;
        }
        ++setUpCounter;
    }

    public static synchronized void checkTearDown() throws Exception {
        if (--setUpCounter < 0) {
            throw new IllegalStateException("Unbalanced setup/teardown");
        }
        if (setUpCounter == 0) {
            TestServerController.oneTimeTearDown();
        }
    }

    public static void setServiceUI(UIServices hook) {
        hookedAuthDialog = hook;
    }

    public static class DelegatingAuthService
    extends UIServices {
        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            if (hookedAuthDialog != null) {
                return hookedAuthDialog.getUsernamePassword(location);
            }
            return null;
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            if (hookedAuthDialog != null) {
                return hookedAuthDialog.getUsernamePassword(location, previousInfo);
            }
            return null;
        }

        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChain, String[] unsignedDetail) {
            return new UIServices.TrustInfo(null, false, true);
        }
    }
}

