/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.AddJVMArgumentAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AddJVMArgumentActionTest
extends AbstractProvisioningTest {
    private static File tempDir;
    private LauncherData launcherData;
    private Map parameters;

    public AddJVMArgumentActionTest(String name) {
        super(name);
    }

    public AddJVMArgumentActionTest() {
        super("");
    }

    public void setUp() throws Exception {
        super.setUp();
        tempDir = new File(System.getProperty("java.io.tmpdir"), "JVMArgs");
        tempDir.mkdirs();
        this.parameters = new HashMap();
        this.parameters.put("agent", AddJVMArgumentActionTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        Properties profileProperties = new Properties();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", this.getTempFolder().toString());
        IProfile profile = this.createProfile("test", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, AddJVMArgumentActionTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", this.parameters);
        this.parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, this.parameters);
        this.parameters.put("profileDataDirectory", tempDir);
        Manipulator manipulator = (Manipulator)this.parameters.get("manipulator");
        AddJVMArgumentActionTest.assertNotNull((Object)manipulator);
        this.launcherData = manipulator.getLauncherData();
    }

    public void tearDown() throws Exception {
        AddJVMArgumentActionTest.delete(tempDir);
        super.tearDown();
    }

    public void testExecuteUndo() {
        String jvmArg = "-Dtest=true";
        AddJVMArgumentActionTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(jvmArg));
        this.parameters.put("jvmArg", jvmArg);
        AddJVMArgumentAction action = new AddJVMArgumentAction();
        action.execute(Collections.unmodifiableMap(this.parameters));
        AddJVMArgumentActionTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(jvmArg));
        action.undo(Collections.unmodifiableMap(this.parameters));
        AddJVMArgumentActionTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(jvmArg));
        String byteArg = "-Xmx256M";
        this.parameters.put("jvmArg", byteArg);
        action.execute(Collections.unmodifiableMap(this.parameters));
        AddJVMArgumentActionTest.assertTrue((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(byteArg));
        action.undo(Collections.unmodifiableMap(this.parameters));
        AddJVMArgumentActionTest.assertFalse((boolean)Arrays.asList(this.launcherData.getJvmArgs()).contains(byteArg));
    }
}

