/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.CheckTrustAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class CheckTrustActionTest
extends AbstractProvisioningTest {
    public CheckTrustActionTest(String name) {
        super(name);
    }

    public CheckTrustActionTest() {
        super("");
    }

    public void testExecuteUndo() throws Exception {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)CheckTrustActionTest.getAgent(), (IProfile)profile);
        File osgiSource = CheckTrustActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        CheckTrustActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        CheckTrustActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", CheckTrustActionTest.getAgent());
        parameters.put("profile", profile);
        parameters.put("artifactFiles", new ArrayList());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters = Collections.unmodifiableMap(parameters);
        CheckTrustActionTest.assertFalse((boolean)((List)parameters.get("artifactFiles")).contains(osgiTarget));
        CheckTrustAction action = new CheckTrustAction();
        action.execute(parameters);
        CheckTrustActionTest.assertTrue((boolean)((List)parameters.get("artifactFiles")).contains(osgiTarget));
        action.undo(parameters);
        CheckTrustActionTest.assertTrue((boolean)((List)parameters.get("artifactFiles")).contains(osgiTarget));
    }
}

