/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.RemoveJVMArgumentAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class RemoveJVMArgumentActionTest
extends AbstractProvisioningTest {
    public RemoveJVMArgumentActionTest(String name) {
        super(name);
    }

    public RemoveJVMArgumentActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", RemoveJVMArgumentActionTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        Properties profileProperties = new Properties();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", this.getTempFolder().toString());
        IProfile profile = this.createProfile("test", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, RemoveJVMArgumentActionTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        RemoveJVMArgumentActionTest.assertNotNull((Object)manipulator);
        String jvmArg = "-Dtest=true";
        manipulator.getLauncherData().addJvmArg(jvmArg);
        RemoveJVMArgumentActionTest.assertTrue((boolean)Arrays.asList(manipulator.getLauncherData().getJvmArgs()).contains(jvmArg));
        parameters.put("jvmArg", jvmArg);
        parameters = Collections.unmodifiableMap(parameters);
        RemoveJVMArgumentAction action = new RemoveJVMArgumentAction();
        action.execute(parameters);
        RemoveJVMArgumentActionTest.assertFalse((boolean)Arrays.asList(manipulator.getLauncherData().getJvmArgs()).contains(jvmArg));
        action.undo(parameters);
        RemoveJVMArgumentActionTest.assertTrue((boolean)Arrays.asList(manipulator.getLauncherData().getJvmArgs()).contains(jvmArg));
    }
}

