/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactDescriptor;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.PlatformConfigurationWrapper;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.UninstallFeatureAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class UninstallFeatureActionTest
extends AbstractProvisioningTest {
    private static final String UPDATE_FEATURE_APPLICATION_PROP = "org.eclipse.update.feature.application";
    private static final String UPDATE_FEATURE_PLUGIN_PROP = "org.eclipse.update.feature.plugin";
    private static final String UPDATE_FEATURE_PRIMARY_PROP = "org.eclipse.update.feature.primary";

    public UninstallFeatureActionTest(String name) {
        super(name);
    }

    public UninstallFeatureActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)UninstallFeatureActionTest.getAgent(), (IProfile)profile);
        File featureSource = UninstallFeatureActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/features/org.eclipse.rcp_3.3.0.v20070607-8y8eE8NEbsN3X_fjWS8HPNG");
        File targetPlugins = new File(installFolder, "features");
        UninstallFeatureActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File featureTarget = new File(targetPlugins, "org.eclipse.rcp_3.3.0.v20070607-8y8eE8NEbsN3X_fjWS8HPNG");
        UninstallFeatureActionTest.copy("2.0", featureSource, featureTarget);
        FeatureParser parser = new FeatureParser();
        Feature feature = parser.parse(featureTarget);
        PublisherInfo info = new PublisherInfo();
        info.setArtifactRepository((IArtifactRepository)bundlePool);
        IArtifactKey key = FeaturesAction.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IPublisherInfo)info, (IArtifactKey)key, (File)featureTarget);
        ((SimpleArtifactDescriptor)descriptor).setRepositoryProperty("artifact.folder", Boolean.TRUE.toString());
        IInstallableUnit iu = FeaturesAction.createFeatureJarIU((Feature)feature, (IPublisherInfo)info);
        bundlePool.addDescriptor(descriptor);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", UninstallFeatureActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("feature", key.toString());
        parameters.put("featureId", "default");
        parameters.put("featureVersion", "default");
        parameters = Collections.unmodifiableMap(parameters);
        PlatformConfigurationWrapper configuration = (PlatformConfigurationWrapper)parameters.get("platformConfiguration");
        UninstallFeatureActionTest.assertNotNull((Object)configuration);
        String pluginId = iu.getProperty(UPDATE_FEATURE_PLUGIN_PROP);
        boolean isPrimary = Boolean.valueOf(iu.getProperty(UPDATE_FEATURE_PRIMARY_PROP));
        String application = iu.getProperty(UPDATE_FEATURE_APPLICATION_PROP);
        String pluginVersion = key.getVersion().toString();
        configuration.addFeatureEntry(featureTarget, feature.getId(), feature.getVersion(), pluginId, pluginVersion, isPrimary, application, null, iu.getProperty("org.eclipse.update.site.linkFile"));
        URI siteURI = featureTarget.getParentFile().getParentFile().toURI();
        UninstallFeatureActionTest.assertTrue((boolean)configuration.containsFeature(siteURI, feature.getId(), feature.getVersion()));
        UninstallFeatureAction action = new UninstallFeatureAction();
        action.execute(parameters);
        UninstallFeatureActionTest.assertFalse((boolean)configuration.containsFeature(siteURI, feature.getId(), feature.getVersion()));
        action.undo(parameters);
        UninstallFeatureActionTest.assertTrue((boolean)configuration.containsFeature(siteURI, feature.getId(), feature.getVersion()));
    }
}

