/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.RemoveAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class RemoveActionTest
extends AbstractProvisioningTest {
    private File testFolder;
    private File testFile;
    private Map parameters;
    private RemoveAction action;

    public RemoveActionTest(String name) {
        super(name);
    }

    public RemoveActionTest() {
        super("");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.testFolder.exists()) {
            RemoveActionTest.delete(this.testFolder);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndo", profileProperties);
        this.parameters = new HashMap();
        this.parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "testExecuteUndo", this.parameters);
        this.testFolder = new File(installFolder, "testExecuteUndo");
        this.testFile = new File(this.testFolder, "data.txt");
        this.parameters.put("path", this.testFolder.getAbsolutePath());
        this.parameters = Collections.unmodifiableMap(this.parameters);
    }

    public void testExecuteUndo() {
        this.executeRemoveActionOnNonEmptyDir();
        this.action.undo(this.parameters);
        IBackupStore store = (IBackupStore)this.parameters.get("backup");
        if (store != null) {
            try {
                store.restore();
            }
            catch (IOException iOException) {
                RemoveActionTest.fail((String)"Restore of backup failed");
            }
        }
        RemoveActionTest.assertTrue((String)"Test folder was not restored from backup", (boolean)this.testFolder.exists());
        RemoveActionTest.assertFileContent("Should contain AA", this.testFile, "AA");
        if (store != null) {
            store.discard();
        }
    }

    public void testExecuteMultipleRemovesOnTheSameDir() {
        this.executeRemoveActionOnNonEmptyDir();
        this.executeRemoveActionOnNonEmptyDir();
    }

    public void testExecuteMultipleRemovesOnTheSameEmptyDir() {
        this.executeRemoveActionOnEmptyDir("Test folder exists after executing RemoveAction for the first time");
        this.executeRemoveActionOnEmptyDir("Test folder exists after executing RemoveAction for the second time");
    }

    public void testExecuteMultipleRemovesOnTheSameEmptyDir2() {
        this.executeRemoveActionOnEmptyDir("Test folder exists after executing RemoveAction for the first time");
        this.executeUncheckedRemoveActionOnNonEmptyDir();
        this.executeRemoveActionOnEmptyDir("Test folder exists after executing RemoveAction for the third time");
    }

    private void writeTestFile() {
        this.testFolder.mkdir();
        RemoveActionTest.assertTrue((String)"Test folder was not created before removal", (boolean)this.testFolder.exists());
        try {
            RemoveActionTest.writeToFile(this.testFile, "AA\nTestfile with AA on first line.");
        }
        catch (IOException iOException) {
            RemoveActionTest.fail((String)"Could not write test data to test file");
        }
        RemoveActionTest.assertFileContent("Test file should contain AA", this.testFile, "AA");
    }

    private void executeRemoveActionOnNonEmptyDir() {
        this.writeTestFile();
        this.action = new RemoveAction();
        this.action.execute(this.parameters);
        RemoveActionTest.assertFalse((String)"Test file exists after executing RemoveAction", (boolean)this.testFile.exists());
        RemoveActionTest.assertFalse((String)"Test folder exists after executing RemoveAction", (boolean)this.testFolder.exists());
    }

    private void executeRemoveActionOnEmptyDir(String failureMessage) {
        this.executeUncheckedRemoveActionOnNonEmptyDir();
        RemoveActionTest.assertFalse((String)failureMessage, (boolean)this.testFolder.exists());
    }

    private void executeUncheckedRemoveActionOnNonEmptyDir() {
        this.testFolder.mkdir();
        RemoveActionTest.assertTrue((String)"Test folder was not created before removal", (boolean)this.testFolder.exists());
        this.action = new RemoveAction();
        this.action.execute(this.parameters);
    }

    private static void writeToFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(writer);
        out.write(content);
        out.close();
    }
}

