/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnzipActionTest
extends AbstractProvisioningTest {
    private static void writeToFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        BufferedWriter out = new BufferedWriter(writer);
        out.write(content);
        out.close();
    }

    public UnzipActionTest() {
        super("");
    }

    public UnzipActionTest(String name) {
        super(name);
    }

    public void testExecuteUndo() {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        File zipSource = UnzipActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        UnzipActionTest.copy("2.0", zipSource, zipTarget);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("test");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"test", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("source", zipTarget.getAbsolutePath());
        parameters.put("target", installFolder.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        File aTxt = new File(installFolder, "a.txt");
        UnzipActionTest.assertFalse((boolean)aTxt.exists());
        UnzipAction action = new UnzipAction();
        action.execute(parameters);
        UnzipActionTest.assertTrue((boolean)aTxt.exists());
        action.undo(parameters);
        UnzipActionTest.assertFalse((boolean)aTxt.exists());
    }

    public void testExecuteUndoBackup() {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndoBackup", profileProperties);
        File zipSource = UnzipActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        UnzipActionTest.copy("2.0", zipSource, zipTarget);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("testExecuteUndoBackup");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"testExecuteUndoBackup", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        Map parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "testExecuteUndoBackup", parameters);
        parameters.put("source", zipTarget.getAbsolutePath());
        parameters.put("target", installFolder.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        File aTxt = new File(installFolder, "a.txt");
        try {
            UnzipActionTest.writeToFile(aTxt, "ORIGINAL-A");
        }
        catch (IOException iOException) {
            UnzipActionTest.fail((String)"Can not write to aTxt");
        }
        UnzipActionTest.assertTrue((boolean)aTxt.exists());
        UnzipAction action = new UnzipAction();
        action.execute(parameters);
        UnzipActionTest.assertTrue((boolean)aTxt.exists());
        UnzipActionTest.assertFileContent("Should contain text 'nothing'", aTxt, "nothing");
        action.undo(parameters);
        IBackupStore backup = (IBackupStore)parameters.get("backup");
        try {
            backup.restore();
        }
        catch (IOException e) {
            UnzipActionTest.fail("Restore of backup failed", e);
        }
        UnzipActionTest.assertFileContent("Should contain text 'ORIGINAL-A'", aTxt, "ORIGINAL-A");
        backup.discard();
    }

    public void testUndoBackUpWithSymbolsInProfileId() {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("Test:With\\Sym/bols", profileProperties);
        File zipSource = UnzipActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        UnzipActionTest.copy("2.0", zipSource, zipTarget);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("Test:With\\Sym/bols");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"Test:With\\Sym/bols", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        Map parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "Test:With\\Sym/bols", parameters);
        parameters.put("source", zipTarget.getAbsolutePath());
        parameters.put("target", installFolder.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        File aTxt = new File(installFolder, "a.txt");
        try {
            UnzipActionTest.writeToFile(aTxt, "ORIGINAL-A");
        }
        catch (IOException iOException) {
            UnzipActionTest.fail((String)"Can not write to aTxt");
        }
        UnzipActionTest.assertTrue((boolean)aTxt.exists());
        UnzipAction action = new UnzipAction();
        action.execute(parameters);
        action.undo(parameters);
        IBackupStore backup = (IBackupStore)parameters.get("backup");
        try {
            backup.restore();
        }
        catch (IOException e) {
            UnzipActionTest.fail("Restore of backup failed", e);
        }
        UnzipActionTest.assertFileContent("Should contain text 'ORIGINAL-A'", aTxt, "ORIGINAL-A");
        backup.discard();
    }

    public void testPath() {
        String a = "a.txt";
        String b = "foo/b.txt";
        String c = "foo/bar/car/c.txt";
        String b1 = "b.txt";
        String c1 = "bar/car/c.txt";
        String c2 = "car/c.txt";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("path", "foo");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{b1, c1}, new String[]{a, b, c});
        parameters = new HashMap();
        parameters.put("path", "foo/");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{b1, c1}, new String[]{a, b, c});
        parameters = new HashMap();
        parameters.put("path", "**/bar");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{c2}, new String[]{a, b, c, b1});
    }

    public void testInclusion() {
        String a = "a.txt";
        String b = "foo/b.txt";
        String c = "foo/bar/car/c.txt";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("include", "foo/b.txt");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{b}, new String[]{a, c});
        parameters = new HashMap();
        parameters.put("include", "*/b.txt");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{b}, new String[]{a, c});
        parameters = new HashMap();
        parameters.put("include", "**/c.txt");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{c}, new String[]{a, b});
    }

    public void testExclusion() {
        String a = "a.txt";
        String b = "foo/b.txt";
        String c = "foo/bar/car/c.txt";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("exclude", "foo/b.txt");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{a, c}, new String[]{b});
        parameters = new HashMap();
        parameters.put("exclude", "*/b.txt");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{a, c}, new String[]{b});
        parameters = new HashMap();
        parameters.put("exclude", "**/c.txt");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{a, b}, new String[]{c});
    }

    public void testInclusionAndExclusion() {
        String a = "a.txt";
        String b = "foo/b.txt";
        String c = "foo/bar/car/c.txt";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("include", "*.txt");
        parameters.put("exclude", "**/c.txt");
        this.testUnzip(parameters, this.getTempFolder(), new String[]{a, b}, new String[]{c});
    }

    private void testUnzip(Map<String, String> params, File installFolder, String[] shoudlExistNames, String[] shoudlNotExistNames) {
        File file;
        String fileName;
        ArrayList<File> shoudlExist = new ArrayList<File>();
        ArrayList<File> shoudlNotExist = new ArrayList<File>();
        String[] stringArray = shoudlExistNames;
        int n = shoudlExistNames.length;
        int n2 = 0;
        while (n2 < n) {
            fileName = stringArray[n2];
            file = new File(installFolder, fileName);
            shoudlExist.add(file);
            UnzipActionTest.assertFalse((String)("File " + file.getPath() + " should not exist"), (boolean)file.exists());
            ++n2;
        }
        stringArray = shoudlNotExistNames;
        n = shoudlNotExistNames.length;
        n2 = 0;
        while (n2 < n) {
            fileName = stringArray[n2];
            file = new File(installFolder, fileName);
            shoudlNotExist.add(file);
            UnzipActionTest.assertFalse((String)("File " + file.getPath() + " should not exist"), (boolean)file.exists());
            ++n2;
        }
        Properties profileProperties = new Properties();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        File zipSource = UnzipActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.dir.zip");
        File zipTarget = new File(installFolder, "a.dir.zip");
        UnzipActionTest.copy("2.0", zipSource, zipTarget);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("test");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"test", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("source", zipTarget.getAbsolutePath());
        parameters.put("target", installFolder.getAbsolutePath());
        parameters.putAll(params);
        parameters = Collections.unmodifiableMap(parameters);
        UnzipAction action = new UnzipAction();
        action.execute(parameters);
        for (File file2 : shoudlExist) {
            UnzipActionTest.assertTrue((String)("File " + file2.getPath() + " should exist"), (boolean)file2.exists());
        }
        for (File file2 : shoudlNotExist) {
            UnzipActionTest.assertFalse((String)("File " + file2.getPath() + " should not exist"), (boolean)file2.exists());
        }
        action.undo(parameters);
        for (File file2 : shoudlExist) {
            UnzipActionTest.assertFalse((String)("File " + file2.getPath() + " should not exist"), (boolean)file2.exists());
        }
        for (File file2 : shoudlNotExist) {
            UnzipActionTest.assertFalse((String)("File " + file2.getPath() + " should not exist"), (boolean)file2.exists());
        }
    }
}

