/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatechecker;

import java.util.Arrays;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.junit.Assert;

public class TestUpdateListener
implements IUpdateListener {
    private static final long MAX_WAIT = 5000L;
    private UpdateEvent expectedEvent;
    int expectedCount = 0;
    int unexpectedCount = 0;

    public TestUpdateListener(UpdateEvent event) {
        this.expectedEvent = event;
    }

    public boolean matches(Object o) {
        if (!(o instanceof UpdateEvent)) {
            return false;
        }
        UpdateEvent actual = (UpdateEvent)o;
        return Arrays.equals(this.expectedEvent.getIUs().toArray(), actual.getIUs().toArray()) && this.expectedEvent.getProfileId().equals(actual.getProfileId());
    }

    public void updatesAvailable(UpdateEvent event) {
        if (this.matches(event)) {
            ++this.expectedCount;
        } else {
            ++this.unexpectedCount;
        }
    }

    public void verify(int expected) {
        Assert.assertEquals((long)expected, (long)this.expectedCount);
        Assert.assertEquals((long)0L, (long)this.unexpectedCount);
    }

    public void waitForEvent() {
        long waitStart = System.currentTimeMillis();
        while (this.expectedCount == 0 && this.unexpectedCount == 0 && System.currentTimeMillis() - waitStart < 5000L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void reset() {
        this.unexpectedCount = 0;
        this.expectedCount = 0;
    }
}

