/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatesite;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;

public class CategoryIUXMLActionTest
extends AbstractProvisioningTest {
    private TestMetadataRepository metadataRepository;
    private IPublisherResult actionResult;
    private URI siteLocation;

    protected void setUp() throws Exception {
        super.setUp();
        this.actionResult = new PublisherResult();
        PublisherInfo info = new PublisherInfo();
        this.metadataRepository = new TestMetadataRepository(CategoryIUXMLActionTest.getAgent(), new IInstallableUnit[0]);
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/" + this.getName() + ".xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        featuresAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
    }

    public void testIUCategoryCreation01() throws Exception {
        this.doCategorySetTest();
    }

    public void testIUCategoryCreation02() throws Exception {
        this.doCategorySetTest();
    }

    public void testIUCategoryCreation03() throws Exception {
        this.doCategorySetTest();
    }

    public void testIUCategoryCreation04() throws Exception {
        this.doCategoryNotSetTest();
    }

    public void testIUCategoryCreation05() throws Exception {
        this.doCategoryNotSetTest();
    }

    public void testIUCategoryCreation06() throws Exception {
        this.doCategoryNotSetTest();
    }

    private void doCategorySetTest() {
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryIUXMLActionTest.assertEquals((String)"1.0", (int)1, (int)CategoryIUXMLActionTest.queryResultSize(result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        CategoryIUXMLActionTest.assertEquals((String)"1.1", (String)"Test Category Label", (String)iu.getProperty("org.eclipse.equinox.p2.name"));
    }

    private void doCategoryNotSetTest() {
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryIUXMLActionTest.assertEquals((String)"1.0", (int)0, (int)CategoryIUXMLActionTest.queryResultSize(result));
    }
}

