/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatesite;

import java.io.File;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.CategoryXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.MergeResultsAction;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;

public class CategoryXMLActionTest
extends AbstractProvisioningTest {
    private TestMetadataRepository metadataRepository;
    private IPublisherResult actionResult;
    private URI siteLocation;

    protected void setUp() throws Exception {
        super.setUp();
        this.actionResult = new PublisherResult();
        this.metadataRepository = new TestMetadataRepository(CategoryXMLActionTest.getAgent(), new IInstallableUnit[0]);
    }

    public void testCategoryCreation() throws Exception {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/category.xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        featuresAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"1.0", (int)1, (int)CategoryXMLActionTest.queryResultSize(result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        CategoryXMLActionTest.assertEquals((String)"1.1", (String)"Test Category Label", (String)iu.getProperty("org.eclipse.equinox.p2.name"));
    }

    public void testCategoryCreationMultiFeature() throws Exception {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/category01.xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        featuresAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"1.0", (int)1, (int)CategoryXMLActionTest.queryResultSize(result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        CategoryXMLActionTest.assertEquals((String)"1.1", (String)"Test Category Label", (String)iu.getProperty("org.eclipse.equinox.p2.name"));
        IQuery memberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)iu);
        IQueryResult categoryMembers = this.actionResult.query(memberQuery, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"2.0", (int)3, (int)categoryMembers.toUnmodifiableSet().size());
    }

    public void testCategoryCreationMultiFeatureQualifier() throws Exception {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/category02.xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        featuresAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"1.0", (int)1, (int)CategoryXMLActionTest.queryResultSize(result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        CategoryXMLActionTest.assertEquals((String)"1.1", (String)"Test Category Label", (String)iu.getProperty("org.eclipse.equinox.p2.name"));
        IQuery memberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)iu);
        IQueryResult categoryMembers = this.actionResult.query(memberQuery, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"2.0", (int)2, (int)categoryMembers.toUnmodifiableSet().size());
    }

    public void testBundlesInCategory() throws Exception {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/categoryWithBundle.xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        BundlesAction bundlesAction = new BundlesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        MergeResultsAction publishAction = new MergeResultsAction(new IPublisherAction[]{featuresAction, bundlesAction}, 2);
        publishAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"1.0", (int)1, (int)CategoryXMLActionTest.queryResultSize(result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        CategoryXMLActionTest.assertEquals((String)"1.1", (String)"Test Category Label", (String)iu.getProperty("org.eclipse.equinox.p2.name"));
        IQuery memberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)iu);
        IQueryResult categoryMembers = this.actionResult.query(memberQuery, (IProgressMonitor)new NullProgressMonitor());
        Set categoryMembersSet = categoryMembers.toUnmodifiableSet();
        CategoryXMLActionTest.assertEquals((String)"2.0", (int)1, (int)categoryMembersSet.size());
        CategoryXMLActionTest.assertEquals((String)"2.1", (String)"test.bundle", (String)((IInstallableUnit)categoryMembersSet.iterator().next()).getId());
    }

    public void testUncategorizedBundlesInCategory() throws Exception {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/categoryUncategorizedBundle.xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        BundlesAction bundlesAction = new BundlesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        MergeResultsAction publishAction = new MergeResultsAction(new IPublisherAction[]{featuresAction, bundlesAction}, 2);
        publishAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"1.0", (int)1, (int)CategoryXMLActionTest.queryResultSize(result));
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        CategoryXMLActionTest.assertEquals((String)"1.1", (String)"Uncategorized", (String)iu.getProperty("org.eclipse.equinox.p2.name"));
        IQuery memberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)iu);
        IQueryResult categoryMembers = this.actionResult.query(memberQuery, (IProgressMonitor)new NullProgressMonitor());
        Set categoryMembersSet = categoryMembers.toUnmodifiableSet();
        CategoryXMLActionTest.assertEquals((String)"2.0", (int)1, (int)categoryMembersSet.size());
        CategoryXMLActionTest.assertEquals((String)"2.1", (String)"test.bundle", (String)((IInstallableUnit)categoryMembersSet.iterator().next()).getId());
    }

    public void testNestedInCategory() throws Exception {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/categoryNested.xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        BundlesAction bundlesAction = new BundlesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        MergeResultsAction publishAction = new MergeResultsAction(new IPublisherAction[]{featuresAction, bundlesAction}, 2);
        publishAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"1.0", (int)2, (int)CategoryXMLActionTest.queryResultSize(result));
        IInstallableUnit rootCategoryIu = null;
        for (Object item : result) {
            if (!((IInstallableUnit)item).getId().endsWith("Root Category")) continue;
            rootCategoryIu = (IInstallableUnit)item;
        }
        CategoryXMLActionTest.assertNotNull((String)"1.1", rootCategoryIu);
        IInstallableUnit nestedCategory = this.assertContainsAndGetIU(rootCategoryIu, "Nested Category");
        IQuery nestedCategoryMemberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)nestedCategory);
        IQueryResult nestedCategoryMembers = this.actionResult.query(nestedCategoryMemberQuery, (IProgressMonitor)new NullProgressMonitor());
        Set nestedCategoryMembersSet = nestedCategoryMembers.toUnmodifiableSet();
        CategoryXMLActionTest.assertEquals((String)"3.0", (int)1, (int)nestedCategoryMembersSet.size());
        CategoryXMLActionTest.assertEquals((String)"3.1", (String)"test.bundle", (String)((IInstallableUnit)nestedCategoryMembersSet.iterator().next()).getId());
    }

    public void testMultiDepthNestedInCategory() throws Exception {
        PublisherInfo info = new PublisherInfo();
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        this.siteLocation = TestData.getFile("updatesite", "CategoryXMLActionTest/3-depth-category.xml").toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        BundlesAction bundlesAction = new BundlesAction(new File[]{TestData.getFile("updatesite", "CategoryXMLActionTest")});
        MergeResultsAction publishAction = new MergeResultsAction(new IPublisherAction[]{featuresAction, bundlesAction}, 2);
        publishAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLAction action = new CategoryXMLAction(this.siteLocation, null);
        action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        IQueryResult result = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        CategoryXMLActionTest.assertEquals((String)"1.0", (int)4, (int)CategoryXMLActionTest.queryResultSize(result));
        IInstallableUnit rootCategoryIu = null;
        for (Object item : result) {
            if (!((IInstallableUnit)item).getId().endsWith("Root Category")) continue;
            rootCategoryIu = (IInstallableUnit)item;
        }
        CategoryXMLActionTest.assertNotNull((String)"1.1", rootCategoryIu);
        IInstallableUnit nestedCategoryIu = this.assertContainsAndGetIU(rootCategoryIu, "Nested Category");
        IInstallableUnit nestedNestedCategoryIu = this.assertContainsAndGetIU(nestedCategoryIu, "Nested Nested Category");
        IInstallableUnit nestedNestedNestedCategoryIu = this.assertContainsAndGetIU(nestedNestedCategoryIu, "Nested Nested Nested Category");
        IQuery nestedNestedNestedCategoryMemberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)nestedNestedNestedCategoryIu);
        IQueryResult nestedNestedNestedCategoryMembers = this.actionResult.query(nestedNestedNestedCategoryMemberQuery, (IProgressMonitor)new NullProgressMonitor());
        Set nestedCategoryMembersSet = nestedNestedNestedCategoryMembers.toUnmodifiableSet();
        CategoryXMLActionTest.assertEquals((String)"3.0", (int)1, (int)nestedCategoryMembersSet.size());
        CategoryXMLActionTest.assertEquals((String)"3.1", (String)"test.feature.feature.group", (String)((IInstallableUnit)nestedCategoryMembersSet.iterator().next()).getId());
    }

    private IInstallableUnit assertContainsAndGetIU(IInstallableUnit parentCategoryIu, String iuId) {
        IQuery rootCategoryMembersQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)parentCategoryIu);
        IQueryResult rootCategoryMembers = this.actionResult.query(rootCategoryMembersQuery, (IProgressMonitor)new NullProgressMonitor());
        Set rootCategoryMembersSet = rootCategoryMembers.toUnmodifiableSet();
        CategoryXMLActionTest.assertEquals((String)"Unexpected multiple items under category", (int)1, (int)rootCategoryMembersSet.size());
        IInstallableUnit nestedCategoryIu = (IInstallableUnit)rootCategoryMembersSet.iterator().next();
        CategoryXMLActionTest.assertTrue((String)("Could not find IU '" + iuId + "'"), (boolean)nestedCategoryIu.getId().endsWith(iuId));
        return nestedCategoryIu;
    }
}

