/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests;

import java.util.HashSet;
import java.util.Iterator;
import org.easymock.EasyMock;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleIdBasedRegionTests {
    private static final String OTHER_REGION_NAME = "other";
    private static final String BUNDLE_SYMBOLIC_NAME = "b";
    private static final String BUNDLE_SYMBOLIC_NAME_2 = "c";
    private static final Version BUNDLE_VERSION = new Version("1");
    private static final long BUNDLE_ID = 1L;
    private static final long BUNDLE_ID_2 = 2L;
    private static final String REGION_NAME = "reg";
    private static final long TEST_BUNDLE_ID = 99L;
    private Bundle mockBundle;
    private RegionDigraph mockGraph;
    private Iterator<Region> regionIterator;
    private BundleContext mockBundleContext;
    Region mockRegion;
    Region mockRegion2;
    RegionFilter mockRegionFilter;
    private ThreadLocal<Region> threadLocal;
    private Object bundleIdToRegionMapping;

    @Before
    public void setUp() throws Exception {
        this.threadLocal = new ThreadLocal();
        this.mockBundle = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)this.mockBundle.getSymbolicName()).andReturn((Object)BUNDLE_SYMBOLIC_NAME).anyTimes();
        EasyMock.expect((Object)this.mockBundle.getVersion()).andReturn((Object)BUNDLE_VERSION).anyTimes();
        EasyMock.expect((Object)this.mockBundle.getBundleId()).andReturn((Object)1L).anyTimes();
        this.mockBundleContext = (BundleContext)EasyMock.createMock(BundleContext.class);
        EasyMock.expect((Object)this.mockBundleContext.getBundle(1L)).andReturn((Object)this.mockBundle).anyTimes();
        this.mockRegion = (Region)EasyMock.createMock(Region.class);
        this.mockRegion2 = (Region)EasyMock.createMock(Region.class);
        this.mockRegionFilter = (RegionFilter)EasyMock.createMock(RegionFilter.class);
        this.regionIterator = new Iterator<Region>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Region next() {
                return null;
            }

            @Override
            public void remove() {
            }
        };
        this.mockGraph = (RegionDigraph)EasyMock.createMock(RegionDigraph.class);
        this.mockGraph.connect((Region)EasyMock.isA(Region.class), (RegionFilter)EasyMock.eq((Object)this.mockRegionFilter), (Region)EasyMock.eq((Object)this.mockRegion));
        EasyMock.expectLastCall().anyTimes();
        this.bundleIdToRegionMapping = RegionReflectionUtils.newStandardBundleIdToRegionMapping();
    }

    private void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.mockBundleContext, this.mockBundle, this.mockRegion, this.mockRegion2, this.mockRegionFilter, this.mockGraph});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.mockBundleContext, this.mockBundle, this.mockRegion, this.mockRegion2, this.mockRegionFilter, this.mockGraph});
    }

    @Test
    public void testGetName() {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        Assert.assertEquals((Object)REGION_NAME, (Object)r.getName());
    }

    private Region createDefaultBundleIdBasedRegion() {
        return this.createBundleIdBasedRegion(REGION_NAME);
    }

    private Region createBundleIdBasedRegion(String regionName) {
        return RegionReflectionUtils.newBundleIdBasedRegion(regionName, this.mockGraph, this.bundleIdToRegionMapping, this.mockBundleContext, this.threadLocal);
    }

    private void defaultSetUp() {
        EasyMock.expect((Object)this.mockGraph.iterator()).andReturn(this.regionIterator).anyTimes();
        EasyMock.expect((Object)this.mockGraph.getEdges((Region)EasyMock.isA(Region.class))).andReturn(new HashSet()).anyTimes();
        this.replayMocks();
    }

    @Test
    public void testAddBundle() throws BundleException {
        EasyMock.expect((Object)this.mockGraph.iterator()).andReturn(this.regionIterator).anyTimes();
        HashSet<2> edges = new HashSet<2>();
        edges.add(new RegionDigraph.FilteredRegion(){

            public Region getRegion() {
                return null;
            }

            public RegionFilter getFilter() {
                return BundleIdBasedRegionTests.this.mockRegionFilter;
            }
        });
        EasyMock.expect((Object)this.mockGraph.getEdges((Region)EasyMock.isA(Region.class))).andReturn(edges).anyTimes();
        this.replayMocks();
        Region r = this.createDefaultBundleIdBasedRegion();
        r.addBundle(this.mockBundle);
    }

    @Test
    public void testAddExistingBundle() throws BundleException {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        r.addBundle(this.mockBundle);
        r.addBundle(this.mockBundle);
    }

    public void testAddConflictingBundle() throws BundleException {
        this.defaultSetUp();
        Bundle mockBundle2 = (Bundle)EasyMock.createMock(Bundle.class);
        EasyMock.expect((Object)mockBundle2.getSymbolicName()).andReturn((Object)BUNDLE_SYMBOLIC_NAME).anyTimes();
        EasyMock.expect((Object)mockBundle2.getVersion()).andReturn((Object)BUNDLE_VERSION).anyTimes();
        EasyMock.expect((Object)mockBundle2.getBundleId()).andReturn((Object)2L).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockBundle2});
        Region r = this.createDefaultBundleIdBasedRegion();
        r.addBundle(this.mockBundle);
        r.addBundle(mockBundle2);
    }

    @Test(expected=BundleException.class)
    public void testAddBundlePresentInAnotherRegion1() throws BundleException {
        Region r = this.regionForBundlePersentInAnotherRegionTest();
        r.addBundle(this.mockBundle);
    }

    @Test(expected=BundleException.class)
    public void testAddBundlePresentInAnotherRegion2() throws BundleException {
        Region r = this.regionForBundlePersentInAnotherRegionTest();
        r.addBundle(this.mockBundle.getBundleId());
    }

    private Region regionForBundlePersentInAnotherRegionTest() throws BundleException {
        this.regionIterator = new Iterator<Region>(){
            private int next = 2;

            @Override
            public boolean hasNext() {
                return this.next > 0;
            }

            @Override
            public Region next() {
                switch (this.next--) {
                    case 2: {
                        return BundleIdBasedRegionTests.this.mockRegion;
                    }
                }
                return BundleIdBasedRegionTests.this.mockRegion2;
            }

            @Override
            public void remove() {
            }
        };
        EasyMock.expect((Object)this.mockGraph.iterator()).andReturn(this.regionIterator).anyTimes();
        EasyMock.expect((Object)this.mockGraph.getEdges((Region)EasyMock.isA(Region.class))).andReturn(new HashSet()).anyTimes();
        EasyMock.expect((Object)this.mockRegion.contains(EasyMock.eq((long)1L))).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.mockRegion2.contains(EasyMock.eq((long)1L))).andReturn((Object)false).anyTimes();
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        this.replayMocks();
        Region r = this.createDefaultBundleIdBasedRegion();
        return r;
    }

    @Test
    public void testInstallBundleStringInputStream() {
        this.defaultSetUp();
    }

    @Test
    public void testInstallBundleString() {
        this.defaultSetUp();
    }

    @Test
    public void testContains() throws BundleException {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        r.addBundle(this.mockBundle);
        Assert.assertTrue((boolean)r.contains(this.mockBundle));
    }

    @Test
    public void testDoesNotContain() {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        Assert.assertFalse((boolean)r.contains(this.mockBundle));
    }

    @Test
    public void testGetBundle() throws BundleException {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        r.addBundle(this.mockBundle);
        Assert.assertEquals((Object)this.mockBundle, (Object)r.getBundle(BUNDLE_SYMBOLIC_NAME, BUNDLE_VERSION));
    }

    @Test
    public void testGetBundleNotFound() throws BundleException {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        r.addBundle(this.mockBundle);
        Assert.assertNull((Object)r.getBundle(BUNDLE_SYMBOLIC_NAME_2, BUNDLE_VERSION));
    }

    @Test
    public void testConnectRegion() throws BundleException {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        r.connectRegion(this.mockRegion, this.mockRegionFilter);
    }

    @Test
    public void testEquals() {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        Region s = this.createDefaultBundleIdBasedRegion();
        Assert.assertEquals((Object)r, (Object)r);
        Assert.assertEquals((Object)r, (Object)s);
        Assert.assertEquals((long)r.hashCode(), (long)s.hashCode());
    }

    @Test
    public void testNotEqual() {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        Region s = this.createBundleIdBasedRegion(OTHER_REGION_NAME);
        Assert.assertFalse((boolean)r.equals(s));
        Assert.assertFalse((boolean)r.equals(null));
    }

    @Test
    public void testAddRemoveBundleId() throws BundleException {
        this.defaultSetUp();
        Region r = this.createDefaultBundleIdBasedRegion();
        r.addBundle(99L);
        Assert.assertTrue((boolean)r.contains(99L));
        r.removeBundle(99L);
        Assert.assertFalse((boolean)r.contains(99L));
    }
}

