/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.junit.Assert;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;

public class RegionReflectionUtils {
    private static final ClassLoader regionCL = Region.class.getClassLoader();
    private static final String BundleIdBasedRegion = "org.eclipse.equinox.internal.region.BundleIdBasedRegion";
    private static final String StandardBundleIdToRegionMapping = "org.eclipse.equinox.internal.region.StandardBundleIdToRegionMapping";
    private static final String StandardBundleIdToRegionMapping_associateBundleWithRegion = "associateBundleWithRegion";
    private static final String StandardBundleIdToRegionMapping_getRegion = "getRegion";
    private static final String StandardBundleIdToRegionMapping_dissociateBundleFromRegion = "dissociateBundleFromRegion";
    private static final String StandardBundleIdToRegionMapping_isBundleAssociatedWithRegion = "isBundleAssociatedWithRegion";
    private static final String StandardBundleIdToRegionMapping_getBundleIds = "getBundleIds";
    private static final String StandardBundleIdToRegionMapping_clear = "clear";
    private static final String StandardRegionDigraph = "org.eclipse.equinox.internal.region.StandardRegionDigraph";
    private static final String StandardRegionFilterBuilder = "org.eclipse.equinox.internal.region.StandardRegionFilterBuilder";
    private static final String RegionBundleCollisionHook = "org.eclipse.equinox.internal.region.hook.RegionBundleCollisionHook";
    private static final String RegionBundleEventHook = "org.eclipse.equinox.internal.region.hook.RegionBundleEventHook";
    private static final String RegionBundleFindHook = "org.eclipse.equinox.internal.region.hook.RegionBundleFindHook";
    private static final String RegionResolverHook = "org.eclipse.equinox.internal.region.hook.RegionResolverHook";
    private static final String RegionServiceEventHook = "org.eclipse.equinox.internal.region.hook.RegionServiceEventHook";
    private static final String RegionServiceFindHook = "org.eclipse.equinox.internal.region.hook.RegionServiceFindHook";
    private static final String BundleIdToRegionMapping = "org.eclipse.equinox.internal.region.BundleIdToRegionMapping";

    public static Object newStandardBundleIdToRegionMapping() {
        Class<?> clazz = RegionReflectionUtils.loadRegionImplClass(StandardBundleIdToRegionMapping);
        return RegionReflectionUtils.newInstance(clazz);
    }

    private static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)e.getMessage());
        }
        return null;
    }

    private static Class<?> loadRegionImplClass(String name) {
        try {
            return regionCL.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    public static Region newBundleIdBasedRegion(String regionName, RegionDigraph regionDigraph, Object bundleIdToRegionMapping, BundleContext bundleContext, ThreadLocal<Region> threadLocal) {
        Class<?> bundleIdBasedRegionClazz = RegionReflectionUtils.loadRegionImplClass(BundleIdBasedRegion);
        Class<?> bundleIdToRegionMappingClazz = RegionReflectionUtils.loadRegionImplClass(BundleIdToRegionMapping);
        Class[] classParams = new Class[]{String.class, RegionDigraph.class, bundleIdToRegionMappingClazz, BundleContext.class, ThreadLocal.class};
        Object[] constructorArgs = new Object[]{regionName, regionDigraph, bundleIdToRegionMapping, bundleContext, threadLocal};
        return (Region)RegionReflectionUtils.newInstance(bundleIdBasedRegionClazz, classParams, constructorArgs);
    }

    private static Object newInstance(Class<?> clazz, Class<?>[] parameterTypes, Object[] constructorArgs) {
        try {
            Constructor<?> constructor = clazz.getConstructor(parameterTypes);
            return constructor.newInstance(constructorArgs);
        }
        catch (SecurityException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InstantiationException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)e.getMessage());
        }
        return null;
    }

    public static void associateBundleWithRegion(Object bundleIdToRegionMapping, long bundleId, Region region) {
        RegionReflectionUtils.callMethod(bundleIdToRegionMapping, StandardBundleIdToRegionMapping_associateBundleWithRegion, new Class[]{Long.TYPE, Region.class}, new Object[]{bundleId, region});
    }

    public static void dissociateBundleFromRegion(Object bundleIdToRegionMapping, long bundleId, Region region) {
        RegionReflectionUtils.callMethod(bundleIdToRegionMapping, StandardBundleIdToRegionMapping_dissociateBundleFromRegion, new Class[]{Long.TYPE, Region.class}, new Object[]{bundleId, region});
    }

    private static Object callMethod(Object target, String methodName, Class<?>[] paramTypes, Object[] paramArgs) {
        try {
            Method method = target.getClass().getMethod(methodName, paramTypes);
            return method.invoke(target, paramArgs);
        }
        catch (SecurityException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            Assert.fail((String)e.getMessage());
        }
        return null;
    }

    public static Region getRegion(Object bundleIdToRegionMapping, long testBundleId) {
        return (Region)RegionReflectionUtils.callMethod(bundleIdToRegionMapping, StandardBundleIdToRegionMapping_getRegion, new Class[]{Long.TYPE}, new Object[]{testBundleId});
    }

    public static boolean isBundleAssociatedWithRegion(Object bundleIdToRegionMapping, long testBundleId, Region region) {
        return (Boolean)RegionReflectionUtils.callMethod(bundleIdToRegionMapping, StandardBundleIdToRegionMapping_isBundleAssociatedWithRegion, new Class[]{Long.TYPE, Region.class}, new Object[]{testBundleId, region});
    }

    public static Set<Long> getBundleIds(Object bundleIdToRegionMapping, Region region) {
        return (Set)RegionReflectionUtils.callMethod(bundleIdToRegionMapping, StandardBundleIdToRegionMapping_getBundleIds, new Class[]{Region.class}, new Object[]{region});
    }

    public static void clear(Object bundleIdToRegionMapping) {
        RegionReflectionUtils.callMethod(bundleIdToRegionMapping, StandardBundleIdToRegionMapping_clear, null, null);
    }

    public static RegionDigraph newStandardRegionDigraph(BundleContext systemBundleContext, ThreadLocal<Region> threadLocal) {
        Class<?> standardRegionDigraphClazz = RegionReflectionUtils.loadRegionImplClass(StandardRegionDigraph);
        Class[] classParams = new Class[]{BundleContext.class, ThreadLocal.class};
        Object[] constructorArgs = new Object[]{systemBundleContext, threadLocal};
        return (RegionDigraph)RegionReflectionUtils.newInstance(standardRegionDigraphClazz, classParams, constructorArgs);
    }

    public static RegionDigraph newStandardRegionDigraph() {
        Class<?> standardRegionDigraphClazz = RegionReflectionUtils.loadRegionImplClass(StandardRegionDigraph);
        Class[] classParams = new Class[]{standardRegionDigraphClazz};
        Object[] constructorArgs = new Object[1];
        return (RegionDigraph)RegionReflectionUtils.newInstance(standardRegionDigraphClazz, classParams, constructorArgs);
    }

    public static RegionFilterBuilder newStandardRegionFilterBuilder() {
        Class<?> standardRegionFilterBuilderClazz = RegionReflectionUtils.loadRegionImplClass(StandardRegionFilterBuilder);
        return (RegionFilterBuilder)RegionReflectionUtils.newInstance(standardRegionFilterBuilderClazz);
    }

    public static CollisionHook newRegionBundleCollisionHook(RegionDigraph digraph, ThreadLocal<Region> threadLocal) {
        Class<?> regionBundleCollisionHook = RegionReflectionUtils.loadRegionImplClass(RegionBundleCollisionHook);
        Class[] classParams = new Class[]{RegionDigraph.class, ThreadLocal.class};
        Object[] constructorArgs = new Object[]{digraph, threadLocal};
        return (CollisionHook)RegionReflectionUtils.newInstance(regionBundleCollisionHook, classParams, constructorArgs);
    }

    public static org.osgi.framework.hooks.bundle.EventHook newRegionBundleEventHook(RegionDigraph digraph, org.osgi.framework.hooks.bundle.FindHook findHook, ThreadLocal<Region> threadLocal) {
        Class<?> regionBundleEventHook = RegionReflectionUtils.loadRegionImplClass(RegionBundleEventHook);
        Class[] classParams = new Class[]{RegionDigraph.class, org.osgi.framework.hooks.bundle.FindHook.class, ThreadLocal.class};
        Object[] constructorArgs = new Object[]{digraph, findHook, threadLocal};
        return (org.osgi.framework.hooks.bundle.EventHook)RegionReflectionUtils.newInstance(regionBundleEventHook, classParams, constructorArgs);
    }

    public static org.osgi.framework.hooks.bundle.FindHook newRegionBundleFindHook(RegionDigraph digraph, long bundleId) {
        Class<?> regionBundleFindHook = RegionReflectionUtils.loadRegionImplClass(RegionBundleFindHook);
        Class[] classParams = new Class[]{RegionDigraph.class, Long.TYPE};
        Object[] constructorArgs = new Object[]{digraph, bundleId};
        return (org.osgi.framework.hooks.bundle.FindHook)RegionReflectionUtils.newInstance(regionBundleFindHook, classParams, constructorArgs);
    }

    public static ResolverHook newRegionResolverHook(RegionDigraph digraph) {
        Class<?> regionResolverHook = RegionReflectionUtils.loadRegionImplClass(RegionResolverHook);
        Class[] classParams = new Class[]{RegionDigraph.class};
        Object[] constructorArgs = new Object[]{digraph};
        return (ResolverHook)RegionReflectionUtils.newInstance(regionResolverHook, classParams, constructorArgs);
    }

    public static EventHook newRegionServiceEventHook(FindHook findHook) {
        Class<?> regionServiceEventHook = RegionReflectionUtils.loadRegionImplClass(RegionServiceEventHook);
        Class[] classParams = new Class[]{FindHook.class};
        Object[] constructorArgs = new Object[]{findHook};
        return (EventHook)RegionReflectionUtils.newInstance(regionServiceEventHook, classParams, constructorArgs);
    }

    public static FindHook newRegionServiceFindHook(RegionDigraph digraph) {
        Class<?> regionServiceFindHook = RegionReflectionUtils.loadRegionImplClass(RegionServiceFindHook);
        Class[] classParams = new Class[]{RegionDigraph.class};
        Object[] constructorArgs = new Object[]{digraph};
        return (FindHook)RegionReflectionUtils.newInstance(regionServiceFindHook, classParams, constructorArgs);
    }
}

