/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests;

import org.easymock.EasyMock;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleException;

public class StandardBundleIdToRegionMappingTests {
    private Object bundleIdToRegionMapping;
    private Region mockRegion;
    private static final long TEST_BUNDLE_ID = 1L;
    private static final long OTHER_TEST_BUNDLE_ID = 2L;

    @Before
    public void setUp() throws Exception {
        this.bundleIdToRegionMapping = RegionReflectionUtils.newStandardBundleIdToRegionMapping();
        this.mockRegion = (Region)EasyMock.createMock(Region.class);
    }

    @Test
    public void testAssociateBundleWithRegion() {
        Assert.assertNull((Object)RegionReflectionUtils.getRegion(this.bundleIdToRegionMapping, 1L));
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        Assert.assertEquals((Object)this.mockRegion, (Object)RegionReflectionUtils.getRegion(this.bundleIdToRegionMapping, 1L));
    }

    @Test
    public void testAssociateBundleAlreadyAssociatedWithRegion() {
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
    }

    @Test(expected=BundleException.class)
    public void testAssociateBundleAlreadyAssociatedWithOtherRegion() {
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, (Region)EasyMock.createMock(Region.class));
    }

    @Test
    public void testDissociateBundle() {
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        RegionReflectionUtils.dissociateBundleFromRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        Assert.assertNull((Object)RegionReflectionUtils.getRegion(this.bundleIdToRegionMapping, 1L));
    }

    @Test
    public void testIsBundleAssociatedWithRegion() {
        Assert.assertFalse((boolean)RegionReflectionUtils.isBundleAssociatedWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion));
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        Assert.assertFalse((boolean)RegionReflectionUtils.isBundleAssociatedWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion));
    }

    @Test
    public void testGetBundleIds() {
        Assert.assertEquals((long)0L, (long)RegionReflectionUtils.getBundleIds(this.bundleIdToRegionMapping, this.mockRegion).size());
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 2L, this.mockRegion);
        Assert.assertEquals((long)2L, (long)RegionReflectionUtils.getBundleIds(this.bundleIdToRegionMapping, this.mockRegion).size());
        Assert.assertTrue((boolean)RegionReflectionUtils.getBundleIds(this.bundleIdToRegionMapping, this.mockRegion).contains(1L));
        Assert.assertTrue((boolean)RegionReflectionUtils.getBundleIds(this.bundleIdToRegionMapping, this.mockRegion).contains(2L));
    }

    @Test
    public void testClear() {
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        RegionReflectionUtils.clear(this.bundleIdToRegionMapping);
        Assert.assertNull((Object)RegionReflectionUtils.getRegion(this.bundleIdToRegionMapping, 1L));
    }

    @Test
    public void testGetRegion() {
        Assert.assertNull((Object)RegionReflectionUtils.getRegion(this.bundleIdToRegionMapping, 1L));
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 1L, this.mockRegion);
        RegionReflectionUtils.associateBundleWithRegion(this.bundleIdToRegionMapping, 2L, this.mockRegion);
        Assert.assertNull((Object)RegionReflectionUtils.getRegion(this.bundleIdToRegionMapping, 1L));
        Assert.assertNull((Object)RegionReflectionUtils.getRegion(this.bundleIdToRegionMapping, 2L));
    }
}

