/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphPersistence;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class StandardRegionDigraphPeristenceTests {
    private RegionDigraph digraph;
    private RegionDigraphPersistence persistence;
    private StubBundleContext systemBundleContext;
    private ThreadLocal<Region> threadLocal;
    private static final String BOOT_REGION = "boot";
    private static final Collection<String> regionNames = Arrays.asList("r0", "r1", "r2", "r3");

    @Before
    public void setUp() throws Exception {
        StubBundle stubSystemBundle = new StubBundle(Long.valueOf(0L), "osgi.framework", new Version("0"), "loc");
        this.systemBundleContext = (StubBundleContext)stubSystemBundle.getBundleContext();
        this.systemBundleContext.addInstalledBundle(new StubBundle[]{stubSystemBundle});
        this.threadLocal = new ThreadLocal();
        this.digraph = RegionReflectionUtils.newStandardRegionDigraph((BundleContext)this.systemBundleContext, this.threadLocal);
        this.persistence = this.digraph.getRegionDigraphPersistence();
        Region boot = this.digraph.createRegion(BOOT_REGION);
        boot.addBundle((Bundle)stubSystemBundle);
        for (String regionName : regionNames) {
            Region region = this.digraph.createRegion(regionName);
            int i = 0;
            while (i < 10) {
                String bsn = String.valueOf(region.getName()) + "." + i;
                StubBundle b = (StubBundle)this.systemBundleContext.installBundle(bsn);
                this.systemBundleContext.addInstalledBundle(new StubBundle[]{b});
                region.addBundle((Bundle)b);
                ++i;
            }
        }
    }

    @Test
    public void testBasic() throws IOException, InvalidSyntaxException, BundleException {
        this.doTest();
    }

    @Test
    public void testSingleConnection() throws InvalidSyntaxException, BundleException, IOException {
        Region tail = null;
        for (Region head : this.digraph) {
            if (tail != null) {
                String name = head.getName();
                tail.connectRegion(head, this.createFilter(String.valueOf(name) + "A", String.valueOf(name) + "B", String.valueOf(name) + "C"));
            }
            tail = head;
        }
        this.doTest();
    }

    @Test
    public void testMultiConnection() throws BundleException, InvalidSyntaxException, IOException {
        ArrayList<Region> tails = new ArrayList<Region>();
        for (Region head : this.digraph) {
            for (Region tail : tails) {
                String name = head.getName();
                tail.connectRegion(head, this.createFilter(String.valueOf(name) + "A", String.valueOf(name) + "B", String.valueOf(name) + "C"));
            }
            tails.add(head);
        }
        this.doTest();
    }

    @Test
    public void testMultiConnectionCycle() throws BundleException, InvalidSyntaxException, IOException {
        ArrayList<Region> tails = new ArrayList<Region>();
        for (Region region : this.digraph) {
            tails.add(region);
        }
        for (Region head : this.digraph) {
            for (Region tail : tails) {
                if (head == tail) continue;
                String name = head.getName();
                tail.connectRegion(head, this.createFilter(String.valueOf(name) + "A", String.valueOf(name) + "B", String.valueOf(name) + "C"));
            }
        }
        this.doTest();
    }

    @Test
    public void testInvalidOperations() throws IOException, InvalidSyntaxException, BundleException {
        Region boot = this.digraph.getRegion(BOOT_REGION);
        Bundle b = boot.installBundle("dynamic.add.a.1", (InputStream)new ByteArrayInputStream(new byte[0]));
        boot.addBundle(b);
        this.systemBundleContext.addInstalledBundle(new StubBundle[]{(StubBundle)b});
        Bundle p = boot.getBundle(b.getSymbolicName(), b.getVersion());
        Assert.assertEquals((Object)b, (Object)p);
        RegionDigraph copy = this.copy(this.digraph);
        Region bootCopy = copy.getRegion(BOOT_REGION);
        p = bootCopy.getBundle(b.getSymbolicName(), b.getVersion());
        Assert.assertNull((Object)p);
        try {
            bootCopy.installBundle("dynamic.add.b.1", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        catch (BundleException bundleException) {}
        try {
            bootCopy.installBundleAtLocation("dynamic.add.b.1", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        catch (BundleException bundleException) {}
        try {
            bootCopy.installBundle("dynamic.add.b.2");
        }
        catch (BundleException bundleException) {}
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPersistentName() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(output);
        dataOut.writeUTF("test");
        dataOut.close();
        byte[] byteArray = output.toByteArray();
        this.readDigraph(byteArray);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidPersistentVersion() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(output);
        dataOut.writeUTF("virgo region digraph");
        dataOut.writeInt(-1);
        dataOut.close();
        byte[] byteArray = output.toByteArray();
        this.readDigraph(byteArray);
    }

    private void readDigraph(byte[] byteArray) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
        try {
            this.persistence.load((InputStream)input);
        }
        finally {
            input.close();
        }
    }

    private void doTest() throws IOException, InvalidSyntaxException, BundleException {
        this.doTest(1);
        this.doTest(10);
    }

    private RegionDigraph copy(RegionDigraph toCopy) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.persistence.save(this.digraph, (OutputStream)output);
        output.close();
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        RegionDigraph copy = this.persistence.load((InputStream)input);
        ((InputStream)input).close();
        return copy;
    }

    private void doTest(int iterations) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int i = 0;
        while (i < iterations) {
            this.persistence.save(this.digraph, (OutputStream)output);
            ++i;
        }
        output.close();
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        int i2 = 0;
        while (i2 < iterations) {
            RegionDigraph copy = this.persistence.load((InputStream)input);
            StandardRegionDigraphPeristenceTests.assertEquals(this.digraph, copy);
            ++i2;
        }
        ((InputStream)input).close();
    }

    private RegionFilter createFilter(String ... input) throws InvalidSyntaxException {
        RegionFilterBuilder builder = this.digraph.createRegionFilterBuilder();
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            builder.allow("org.eclipse.equinox.allow.bundle", "(bundle-symbolic-name=" + param + ")");
            builder.allow("osgi.wiring.host", "(osgi.wiring.host=" + param + ")");
            builder.allow("osgi.wiring.package", "(osgi.wiring.package=" + param + ")");
            builder.allow("osgi.wiring.bundle", "(osgi.wiring.bundle=" + param + ")");
            builder.allow("org.eclipse.equinox.allow.service", "(objectClass=" + param + ")");
            ++n2;
        }
        return builder.build();
    }

    static void assertEquals(RegionDigraph d1, RegionDigraph d2) {
        int rCnt1 = StandardRegionDigraphPeristenceTests.countRegions(d1);
        int rCnt2 = StandardRegionDigraphPeristenceTests.countRegions(d2);
        Assert.assertEquals((long)rCnt1, (long)rCnt2);
        for (Region r1 : d1) {
            Region r2 = d2.getRegion(r1.getName());
            StandardRegionDigraphPeristenceTests.assertEquals(r1, r2);
        }
    }

    static int countRegions(RegionDigraph digraph) {
        return digraph.getRegions().size();
    }

    static void assertEquals(Region r1, Region r2) {
        Assert.assertNotNull((Object)r1);
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((String)"Wrong name", (Object)r1.getName(), (Object)r2.getName());
        Set r1IDs = r1.getBundleIds();
        Set r2IDs = r2.getBundleIds();
        Assert.assertEquals((long)r1IDs.size(), (long)r2IDs.size());
        for (Long id : r1IDs) {
            Assert.assertTrue((String)("Missing id: " + id), (boolean)r2IDs.contains(id));
        }
        StandardRegionDigraphPeristenceTests.assertEquals(r1.getEdges(), r2.getEdges());
    }

    static void assertEquals(Set<RegionDigraph.FilteredRegion> edges1, Set<RegionDigraph.FilteredRegion> edges2) {
        Assert.assertEquals((long)edges1.size(), (long)edges2.size());
        HashMap<String, RegionFilter> edges2Map = new HashMap<String, RegionFilter>();
        for (RegionDigraph.FilteredRegion edge2 : edges2) {
            edges2Map.put(edge2.getRegion().getName(), edge2.getFilter());
        }
        for (RegionDigraph.FilteredRegion edge1 : edges1) {
            RegionFilter filter2 = (RegionFilter)edges2Map.get(edge1.getRegion().getName());
            Assert.assertNotNull((String)("No filter found: " + edge1.getRegion().getName()), (Object)filter2);
            Assert.assertEquals((Object)edge1.getFilter().getSharingPolicy(), (Object)filter2.getSharingPolicy());
        }
    }
}

