/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.region.internal.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.internal.tests.RegionReflectionUtils;
import org.eclipse.equinox.region.internal.tests.StandardRegionDigraphPeristenceTests;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundle;
import org.eclipse.virgo.teststubs.osgi.framework.StubBundleContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class StandardRegionDigraphTests {
    private RegionDigraph digraph;
    private Region mockRegion1;
    private Region mockRegion2;
    private Region mockRegion3;
    private RegionFilter regionFilter1;
    private RegionFilter regionFilter2;
    private Bundle mockBundle;
    private static final String REGION_A = "A";
    private static final String REGION_B = "B";
    private static final String REGION_C = "C";
    private static final String REGION_D = "D";

    @Before
    public void setUp() throws Exception {
        StubBundle stubSystemBundle = new StubBundle(Long.valueOf(0L), "osgi.framework", new Version("0"), "loc");
        StubBundleContext stubBundleContext = new StubBundleContext();
        stubBundleContext.addInstalledBundle(new StubBundle[]{stubSystemBundle});
        this.digraph = RegionReflectionUtils.newStandardRegionDigraph((BundleContext)stubBundleContext, new ThreadLocal<Region>());
        this.mockRegion1 = (Region)EasyMock.createMock(Region.class);
        EasyMock.expect((Object)this.mockRegion1.getName()).andReturn((Object)"mockRegion1").anyTimes();
        EasyMock.expect((Object)this.mockRegion1.getRegionDigraph()).andReturn((Object)this.digraph).anyTimes();
        this.mockRegion2 = (Region)EasyMock.createMock(Region.class);
        EasyMock.expect((Object)this.mockRegion2.getName()).andReturn((Object)"mockRegion2").anyTimes();
        EasyMock.expect((Object)this.mockRegion2.getRegionDigraph()).andReturn((Object)this.digraph).anyTimes();
        this.mockRegion3 = (Region)EasyMock.createMock(Region.class);
        EasyMock.expect((Object)this.mockRegion3.getName()).andReturn((Object)"mockRegion3").anyTimes();
        EasyMock.expect((Object)this.mockRegion3.getRegionDigraph()).andReturn((Object)this.digraph).anyTimes();
        this.mockBundle = (Bundle)EasyMock.createMock(Bundle.class);
    }

    private void setDefaultFilters() {
        this.regionFilter1 = this.digraph.createRegionFilterBuilder().build();
        this.regionFilter2 = this.digraph.createRegionFilterBuilder().build();
    }

    private void setAllowedFilters(String b1Name, Version b1Version, String b2Name, Version b2Version) throws InvalidSyntaxException {
        String filter1 = "(&(org.eclipse.equinox.allow.bundle=" + b1Name + ")(" + "bundle-version" + "=" + b1Version + "))";
        this.regionFilter1 = this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", filter1).build();
        String filter2 = "(&(org.eclipse.equinox.allow.bundle=" + b2Name + ")(" + "bundle-version" + "=" + b2Version + "))";
        this.regionFilter2 = this.digraph.createRegionFilterBuilder().allow("org.eclipse.equinox.allow.bundle", filter2).build();
    }

    private void replayMocks() {
        EasyMock.replay((Object[])new Object[]{this.mockRegion1, this.mockRegion2, this.mockRegion3, this.mockBundle});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.mockRegion1, this.mockRegion2, this.mockRegion3, this.mockBundle});
    }

    @Test
    public void testConnect() throws BundleException {
        this.setDefaultFilters();
        this.replayMocks();
        this.digraph.connect(this.mockRegion1, this.regionFilter1, this.mockRegion2);
    }

    @Test
    public void testConnectWithFilterContents() throws BundleException, InvalidSyntaxException {
        String b1Name = "b1";
        Version b1Version = new Version("0");
        String b2Name = "b2";
        Version b2Version = new Version("0");
        this.setAllowedFilters(b1Name, b1Version, b2Name, b2Version);
        EasyMock.expect((Object)this.mockRegion1.getBundle(b1Name, b1Version)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockRegion1.getBundle(b2Name, b2Version)).andReturn(null).anyTimes();
        this.replayMocks();
        this.digraph.connect(this.mockRegion1, this.regionFilter1, this.mockRegion2);
        this.digraph.connect(this.mockRegion1, this.regionFilter2, this.mockRegion3);
    }

    @Test(expected=BundleException.class)
    public void testConnectLoop() throws BundleException {
        this.setDefaultFilters();
        this.replayMocks();
        this.digraph.connect(this.mockRegion1, this.regionFilter1, this.mockRegion1);
    }

    @Test(expected=BundleException.class)
    public void testDuplicateConnection() throws BundleException {
        this.setDefaultFilters();
        this.replayMocks();
        this.digraph.connect(this.mockRegion1, this.regionFilter1, this.mockRegion2);
        this.digraph.connect(this.mockRegion1, this.regionFilter2, this.mockRegion2);
    }

    @Test
    public void testGetEdges() throws BundleException {
        this.setDefaultFilters();
        this.replayMocks();
        this.digraph.connect(this.mockRegion1, this.regionFilter1, this.mockRegion2);
        this.digraph.connect(this.mockRegion1, this.regionFilter2, this.mockRegion3);
        this.digraph.connect(this.mockRegion2, this.regionFilter2, this.mockRegion1);
        Set edges = this.digraph.getEdges(this.mockRegion1);
        Assert.assertEquals((long)2L, (long)edges.size());
        for (RegionDigraph.FilteredRegion edge : edges) {
            if (edge.getRegion().equals(this.mockRegion2)) {
                Assert.assertEquals((Object)this.regionFilter1, (Object)edge.getFilter());
                continue;
            }
            if (edge.getRegion().equals(this.mockRegion3)) {
                Assert.assertEquals((Object)this.regionFilter2, (Object)edge.getFilter());
                continue;
            }
            Assert.fail((String)"unexpected edge");
        }
    }

    @Test
    public void testRemoveRegion() throws BundleException {
        this.setDefaultFilters();
        this.replayMocks();
        this.digraph.connect(this.mockRegion1, this.regionFilter1, this.mockRegion2);
        this.digraph.connect(this.mockRegion2, this.regionFilter2, this.mockRegion1);
        Assert.assertNotNull((Object)this.digraph.getRegion("mockRegion1"));
        Assert.assertNotNull((Object)this.digraph.getRegion("mockRegion2"));
        this.digraph.removeRegion(this.mockRegion1);
        Assert.assertNull((Object)this.digraph.getRegion("mockRegion1"));
        Assert.assertNotNull((Object)this.digraph.getRegion("mockRegion2"));
    }

    @Test
    public void testGetRegions() throws BundleException {
        this.setDefaultFilters();
        this.replayMocks();
        this.digraph.connect(this.mockRegion1, this.regionFilter1, this.mockRegion2);
        Set regions = this.digraph.getRegions();
        Assert.assertEquals((long)2L, (long)regions.size());
        Assert.assertTrue((boolean)regions.contains(this.mockRegion1));
        Assert.assertTrue((boolean)regions.contains(this.mockRegion2));
    }

    @Test
    public void testCopyRegion() throws BundleException, InvalidSyntaxException {
        this.replayMocks();
        RegionDigraph testDigraph = RegionReflectionUtils.newStandardRegionDigraph();
        long bundleId = 1L;
        Region a = testDigraph.createRegion(REGION_A);
        a.addBundle(bundleId++);
        a.addBundle(bundleId++);
        Region b = testDigraph.createRegion(REGION_B);
        b.addBundle(bundleId++);
        b.addBundle(bundleId++);
        Region c = testDigraph.createRegion(REGION_C);
        c.addBundle(bundleId++);
        c.addBundle(bundleId++);
        Region d = testDigraph.createRegion(REGION_D);
        d.addBundle(bundleId++);
        d.addBundle(bundleId++);
        testDigraph.connect(a, testDigraph.createRegionFilterBuilder().allow("a", "(a=x)").build(), b);
        testDigraph.connect(b, testDigraph.createRegionFilterBuilder().allow("b", "(b=x)").build(), c);
        testDigraph.connect(c, testDigraph.createRegionFilterBuilder().allow("c", "(c=x)").build(), d);
        testDigraph.connect(d, testDigraph.createRegionFilterBuilder().allow("d", "(d=x)").build(), a);
        RegionDigraph testCopy = testDigraph.copy();
        StandardRegionDigraphPeristenceTests.assertEquals(testDigraph, testCopy);
        a = testCopy.getRegion(REGION_A);
        b = testCopy.getRegion(REGION_B);
        c = testCopy.getRegion(REGION_C);
        d = testCopy.getRegion(REGION_D);
        for (Region region : testCopy) {
            testCopy.removeRegion(region);
        }
        testCopy.connect(a, testCopy.createRegionFilterBuilder().allow("a", "(a=x)").build(), d);
        testCopy.connect(b, testCopy.createRegionFilterBuilder().allow("b", "(b=x)").build(), a);
        testCopy.connect(c, testCopy.createRegionFilterBuilder().allow("c", "(c=x)").build(), b);
        testCopy.connect(d, testCopy.createRegionFilterBuilder().allow("d", "(d=x)").build(), c);
        try {
            StandardRegionDigraphPeristenceTests.assertEquals(testDigraph, testCopy);
            Assert.fail((String)"Digraphs must not be equal");
        }
        catch (AssertionError assertionError) {}
        testDigraph.replace(testCopy);
        StandardRegionDigraphPeristenceTests.assertEquals(testDigraph, testCopy);
        Region testAdd1 = testCopy.createRegion("testAdd1");
        testCopy.connect(testAdd1, testCopy.createRegionFilterBuilder().allow("testAdd1", "(testAdd=x)").build(), a);
        try {
            StandardRegionDigraphPeristenceTests.assertEquals(testDigraph, testCopy);
            Assert.fail((String)"Digraphs must not be equal");
        }
        catch (AssertionError assertionError) {}
        testDigraph.replace(testCopy);
        StandardRegionDigraphPeristenceTests.assertEquals(testDigraph, testCopy);
        testCopy = testDigraph.copy();
        Region origA = testDigraph.getRegion(REGION_A);
        origA.addBundle(bundleId++);
        try {
            testDigraph.replace(testCopy);
            Assert.fail((String)"Digraph changed since copy.");
        }
        catch (BundleException bundleException) {}
        testCopy = testDigraph.copy();
        origA.removeBundle(bundleId);
        try {
            testDigraph.replace(testCopy);
            Assert.fail((String)"Digraph changed since copy.");
        }
        catch (BundleException bundleException) {}
        testCopy = testDigraph.copy();
        Region testAdd2 = testDigraph.createRegion("testAdd2");
        testDigraph.connect(testAdd2, testCopy.createRegionFilterBuilder().allow("testAdd2", "(testAdd=x)").build(), origA);
        try {
            testDigraph.replace(testCopy);
            Assert.fail((String)"Digraph changed since copy.");
        }
        catch (BundleException bundleException) {}
        testCopy = testDigraph.copy();
        testDigraph.removeRegion(testAdd2);
        testDigraph.connect(testAdd2, testCopy.createRegionFilterBuilder().allow("testAdd2", "(testAdd=y)").build(), origA);
        try {
            testDigraph.replace(testCopy);
            Assert.fail((String)"Digraph changed since copy.");
        }
        catch (BundleException bundleException) {}
        testCopy = testDigraph.copy();
        Region origB = testDigraph.getRegion(REGION_B);
        testDigraph.connect(testAdd2, testCopy.createRegionFilterBuilder().allow("testAdd2", "(testAdd=y)").build(), origB);
        try {
            testDigraph.replace(testCopy);
            Assert.fail((String)"Digraph changed since copy.");
        }
        catch (BundleException bundleException) {}
    }

    @Test
    public void testVisitRegions() throws BundleException, InvalidSyntaxException {
        Collection<Region> visited;
        Region region;
        this.replayMocks();
        RegionDigraph testDigraph = RegionReflectionUtils.newStandardRegionDigraph();
        Region a = testDigraph.createRegion(REGION_A);
        Region b = testDigraph.createRegion(REGION_B);
        Region c = testDigraph.createRegion(REGION_C);
        Region d = testDigraph.createRegion(REGION_D);
        testDigraph.connect(a, testDigraph.createRegionFilterBuilder().allow("b", "(b=x)").allow("c", "(c=x)").allow("d", "(d=x)").build(), b);
        testDigraph.connect(b, testDigraph.createRegionFilterBuilder().allow("c", "(c=x)").allow("d", "(d=x)").build(), c);
        testDigraph.connect(c, testDigraph.createRegionFilterBuilder().allow("d", "(d=x)").build(), d);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("d", "x");
        TestRegionDigraphVisitor visitor = new TestRegionDigraphVisitor("d", attributes);
        ArrayList<Region> expected = new ArrayList<Region>(Arrays.asList(a, b, c, d));
        Region[] regionArray = expected.toArray(new Region[0]);
        int n = regionArray.length;
        int n2 = 0;
        while (n2 < n) {
            region = regionArray[n2];
            testDigraph.visitSubgraph(region, (RegionDigraphVisitor)visitor);
            visited = visitor.clearVisited();
            Assert.assertEquals((String)("Wrong number of visited: " + region), (long)expected.size(), (long)visited.size());
            Assert.assertTrue((String)("Wrong visited content: " + region), (boolean)visited.containsAll(expected));
            expected.remove(region);
            ++n2;
        }
        attributes.clear();
        attributes.put("c", "x");
        visitor = new TestRegionDigraphVisitor("c", attributes);
        expected = new ArrayList<Region>(Arrays.asList(a, b, c));
        regionArray = expected.toArray(new Region[0]);
        n = regionArray.length;
        n2 = 0;
        while (n2 < n) {
            region = regionArray[n2];
            testDigraph.visitSubgraph(region, (RegionDigraphVisitor)visitor);
            visited = visitor.clearVisited();
            Assert.assertEquals((String)("Wrong number of visited: " + region), (long)expected.size(), (long)visited.size());
            Assert.assertTrue((String)("Wrong visited content: " + region), (boolean)visited.containsAll(expected));
            expected.remove(region);
            ++n2;
        }
        attributes.clear();
        attributes.put("b", "x");
        visitor = new TestRegionDigraphVisitor("b", attributes);
        expected = new ArrayList<Region>(Arrays.asList(a, b));
        regionArray = expected.toArray(new Region[0]);
        n = regionArray.length;
        n2 = 0;
        while (n2 < n) {
            region = regionArray[n2];
            testDigraph.visitSubgraph(region, (RegionDigraphVisitor)visitor);
            visited = visitor.clearVisited();
            Assert.assertEquals((String)("Wrong number of visited: " + region), (long)expected.size(), (long)visited.size());
            Assert.assertTrue((String)("Wrong visited content: " + region), (boolean)visited.containsAll(expected));
            expected.remove(region);
            ++n2;
        }
    }

    @Test
    public void testGetHooks() throws BundleException {
        this.setDefaultFilters();
        this.replayMocks();
        Assert.assertNotNull((String)"Resolver Hook is null", (Object)this.digraph.getResolverHookFactory());
        Assert.assertNotNull((String)"Bundle Event Hook is null", (Object)this.digraph.getBundleEventHook());
        Assert.assertNotNull((String)"Bundle Find Hook is null", (Object)this.digraph.getBundleFindHook());
        Assert.assertNotNull((String)"Servie Event Hook is null", (Object)this.digraph.getServiceEventHook());
        Assert.assertNotNull((String)"Service Find Hook is null", (Object)this.digraph.getServiceFindHook());
        RegionDigraph copy = this.digraph.copy();
        Assert.assertNotNull((String)"Resolver Hook is null", (Object)copy.getResolverHookFactory());
        Assert.assertNotNull((String)"Bundle Event Hook is null", (Object)copy.getBundleEventHook());
        Assert.assertNotNull((String)"Bundle Find Hook is null", (Object)copy.getBundleFindHook());
        Assert.assertNotNull((String)"Servie Event Hook is null", (Object)copy.getServiceEventHook());
        Assert.assertNotNull((String)"Service Find Hook is null", (Object)copy.getServiceFindHook());
    }

    static class TestRegionDigraphVisitor
    implements RegionDigraphVisitor {
        final Collection<Region> visited = new ArrayList<Region>();
        final String namespace;
        final Map<String, ?> attributes;

        public TestRegionDigraphVisitor(String namespace, Map<String, ?> attributes) {
            this.namespace = namespace;
            this.attributes = attributes;
        }

        public boolean visit(Region region) {
            this.visited.add(region);
            return true;
        }

        public boolean preEdgeTraverse(RegionFilter regionFilter) {
            return regionFilter.isAllowed(this.namespace, this.attributes);
        }

        public void postEdgeTraverse(RegionFilter regionFilter) {
        }

        Collection<Region> clearVisited() {
            ArrayList<Region> result = new ArrayList<Region>(this.visited);
            this.visited.clear();
            return result;
        }
    }
}

